/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.common.encrypt.MD5;
import com.baomidou.kisso.common.encrypt.SSOEncrypt;
import com.baomidou.kisso.common.util.Base64Util;
import com.baomidou.kisso.exception.KissoException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBE
implements SSOEncrypt {
    public static final String ALGORITHM = "PBEWITHMD5andDES";
    public static final int ITERATION_COUNT = 100;
    private static PBE pbe;

    public static PBE getInstance() {
        if (pbe == null) {
            pbe = new PBE();
        }
        return pbe;
    }

    public static byte[] initSalt() {
        SecureRandom random = new SecureRandom();
        return random.generateSeed(8);
    }

    private static Key toKey(String password) throws Exception {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey secretKey = keyFactory.generateSecret(keySpec);
        return secretKey;
    }

    public static byte[] encrypt(byte[] data, String password, byte[] salt) throws Exception {
        Key key = PBE.toKey(password);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 100);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, key, parameterSpec);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, String password, byte[] salt) throws Exception {
        Key key = PBE.toKey(password);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 100);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, key, parameterSpec);
        return cipher.doFinal(data);
    }

    private static byte[] generateSalt(String key) {
        return MD5.toMD5(key).substring(0, 8).getBytes();
    }

    public static String encryptPBE(String value, String key) {
        try {
            return Base64Util.encryptBASE64(PBE.encrypt(value.getBytes(), key, PBE.generateSalt(key)));
        }
        catch (Exception e) {
            throw new KissoException(e);
        }
    }

    public static String decryptPBE(String value, String key) {
        try {
            return new String(PBE.decrypt(Base64Util.decryptBASE64(value), key, PBE.generateSalt(key)));
        }
        catch (Exception e) {
            throw new KissoException(e);
        }
    }

    public String encrypt(String value, String key) throws Exception {
        return PBE.encryptPBE(value, key);
    }

    public String decrypt(String value, String key) throws Exception {
        return PBE.decryptPBE(value, key);
    }
}

