/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.util;

import com.baomidou.kisso.SSOConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.UrlBase64;

public class Base64Util {
    private static final Logger logger = Logger.getLogger("Base64Util");
    private static final int CACHE_SIZE = 1024;

    public static byte[] decode(String base64) throws Exception {
        return Base64.decode((byte[])base64.getBytes());
    }

    public static String encode(byte[] bytes) throws Exception {
        return new String(Base64.encode((byte[])bytes));
    }

    public static String encryptBASE64(byte[] key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] b = UrlBase64.encode((byte[])key);
        return new String(b, SSOConfig.getSSOEncoding());
    }

    public static byte[] decryptBASE64(String key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return UrlBase64.decode((byte[])key.getBytes(SSOConfig.getSSOEncoding()));
    }

    public static String encodeFile(String filePath) throws Exception {
        byte[] bytes = Base64Util.fileToByte(filePath);
        return Base64Util.encode(bytes);
    }

    public static void decodeToFile(String filePath, String base64) throws Exception {
        byte[] bytes = Base64Util.decode(base64);
        Base64Util.byteArrayToFile(bytes, filePath);
    }

    public static String filePath(String linuxDir, String winDir, String fileName) {
        StringBuffer bf = new StringBuffer();
        if ("\\".equals(File.separator)) {
            bf.append(winDir);
        } else if ("/".equals(File.separator)) {
            bf.append(linuxDir);
        }
        bf.append(File.separator);
        bf.append(fileName);
        return bf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToByte(String filePath) throws Exception {
        byte[] data = new byte[]{};
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            try {
                byte[] cache = new byte[1024];
                int nRead = 0;
                while ((nRead = in.read(cache)) != -1) {
                    out.write(cache, 0, nRead);
                    out.flush();
                }
                data = out.toByteArray();
            }
            catch (Exception e) {
                logger.severe("fileToByte error.");
                e.printStackTrace();
            }
            finally {
                out.close();
                in.close();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byteArrayToFile(byte[] bytes, String filePath) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        File destFile = new File(filePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        destFile.createNewFile();
        FileOutputStream out = new FileOutputStream(destFile);
        try {
            byte[] cache = new byte[1024];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                ((OutputStream)out).write(cache, 0, nRead);
                out.flush();
            }
        }
        catch (Exception e) {
            logger.severe("byteArrayToFile error.");
            e.printStackTrace();
        }
        finally {
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
    }
}

