/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.Version;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.VersionHandler;
import com.baomidou.mybatisplus.toolkit.PluginUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public final class OptimisticLockerInterceptor
implements Interceptor {
    private static final Map<Class<?>, LockerCache> versionCache = new ConcurrentHashMap();
    private static final Map<Class<?>, VersionHandler<?>> typeHandlers = new HashMap();
    private static final Expression RIGHT_EXPRESSION = new Column("?");
    private volatile ParameterMapping parameterMapping;

    private static void registerHandler(VersionHandler<?> versionHandler) {
        Type[] genericInterfaces = versionHandler.getClass().getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType)genericInterfaces[0];
        Class type = (Class)parameterizedType.getActualTypeArguments()[0];
        typeHandlers.put(type, versionHandler);
    }

    public Object intercept(Invocation invocation) throws Exception {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement ms = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!ms.getSqlCommandType().equals((Object)SqlCommandType.UPDATE)) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        Class parameterClass = ms.getParameterMap().getType();
        LockerCache lockerCache = versionCache.get(parameterClass);
        if (lockerCache != null) {
            if (lockerCache.lock) {
                this.processChangeSql(ms, boundSql, lockerCache);
            }
        } else {
            Field versionField = this.getVersionField(parameterClass);
            if (versionField != null) {
                if (!typeHandlers.containsKey(versionField.getType())) {
                    throw new TypeException("\u4e50\u89c2\u9501\u4e0d\u652f\u6301" + versionField.getType().getName() + "\u7c7b\u578b,\u8bf7\u81ea\u5b9a\u4e49\u5b9e\u73b0");
                }
                TableField tableField = versionField.getAnnotation(TableField.class);
                String versionColumn = versionField.getName();
                if (tableField != null) {
                    versionColumn = tableField.value();
                }
                LockerCache lc = new LockerCache(true, versionColumn, versionField);
                versionCache.put(parameterClass, lc);
                this.processChangeSql(ms, boundSql, lc);
            } else {
                versionCache.put(parameterClass, new LockerCache(false));
            }
        }
        return invocation.proceed();
    }

    private Field getVersionField(Class<?> parameterClass) {
        if (parameterClass != Object.class) {
            for (Field field : parameterClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Version.class)) continue;
                field.setAccessible(true);
                return field;
            }
            return this.getVersionField(parameterClass.getSuperclass());
        }
        return null;
    }

    private void processChangeSql(MappedStatement ms, BoundSql boundSql, LockerCache lockerCache) throws Exception {
        Field versionField = lockerCache.field;
        String versionColumn = lockerCache.column;
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject instanceof MapperMethod.ParamMap) {
            Object entity;
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameterObject;
            parameterObject = paramMap.get((Object)"et");
            EntityWrapper entityWrapper = (EntityWrapper)paramMap.get((Object)"ew");
            if (entityWrapper != null && (entity = entityWrapper.getEntity()) != null && versionField.get(entity) == null) {
                this.changSql(ms, boundSql, versionField, versionColumn, parameterObject);
            }
        } else {
            this.changSql(ms, boundSql, versionField, versionColumn, parameterObject);
        }
    }

    private void changSql(MappedStatement ms, BoundSql boundSql, Field versionField, String versionColumn, Object parameterObject) throws Exception {
        Object versionValue = versionField.get(parameterObject);
        if (versionValue != null) {
            Configuration configuration = ms.getConfiguration();
            VersionHandler<?> targetHandler = typeHandlers.get(versionField.getType());
            targetHandler.plusVersion(parameterObject, versionField, versionValue);
            Update jsqlSql = (Update)CCJSqlParserUtil.parse((String)boundSql.getSql());
            BinaryExpression expression = (BinaryExpression)jsqlSql.getWhere();
            if (expression != null && !expression.toString().contains(versionColumn)) {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression((Expression)new Column(versionColumn));
                equalsTo.setRightExpression(RIGHT_EXPRESSION);
                jsqlSql.setWhere((Expression)new AndExpression((Expression)equalsTo, (Expression)expression));
                LinkedList<ParameterMapping> parameterMappings = new LinkedList<ParameterMapping>(boundSql.getParameterMappings());
                parameterMappings.add(jsqlSql.getExpressions().size(), this.getVersionMappingInstance(configuration));
                MetaObject boundSqlMeta = configuration.newMetaObject((Object)boundSql);
                boundSqlMeta.setValue("sql", (Object)jsqlSql.toString());
                boundSqlMeta.setValue("parameterMappings", parameterMappings);
            }
            boundSql.setAdditionalParameter("originVersionValue", versionValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParameterMapping getVersionMappingInstance(Configuration configuration) {
        if (this.parameterMapping != null) return this.parameterMapping;
        Class<OptimisticLockerInterceptor> clazz = OptimisticLockerInterceptor.class;
        synchronized (OptimisticLockerInterceptor.class) {
            if (this.parameterMapping != null) return this.parameterMapping;
            this.parameterMapping = new ParameterMapping.Builder(configuration, "originVersionValue", (TypeHandler)new UnknownTypeHandler(configuration.getTypeHandlerRegistry())).build();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.parameterMapping;
        }
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        String versionHandlers = properties.getProperty("versionHandlers");
        if (StringUtils.isNotEmpty(versionHandlers)) {
            for (String handlerClazz : versionHandlers.split(",")) {
                try {
                    OptimisticLockerInterceptor.registerHandler((VersionHandler)Class.forName(handlerClazz).newInstance());
                }
                catch (Exception e) {
                    throw ExceptionFactory.wrapException((String)"\u4e50\u89c2\u9501\u63d2\u4ef6\u81ea\u5b9a\u4e49\u5904\u7406\u5668\u6ce8\u518c\u5931\u8d25", (Exception)e);
                }
            }
        }
    }

    static {
        ShortTypeHandler shortTypeHandler = new ShortTypeHandler();
        typeHandlers.put(Short.TYPE, shortTypeHandler);
        typeHandlers.put(Short.class, shortTypeHandler);
        IntegerTypeHandler integerTypeHandler = new IntegerTypeHandler();
        typeHandlers.put(Integer.TYPE, integerTypeHandler);
        typeHandlers.put(Integer.class, integerTypeHandler);
        LongTypeHandler longTypeHandler = new LongTypeHandler();
        typeHandlers.put(Long.TYPE, longTypeHandler);
        typeHandlers.put(Long.class, longTypeHandler);
        typeHandlers.put(Date.class, new DateTypeHandler());
        typeHandlers.put(Timestamp.class, new TimestampTypeHandler());
    }

    private class LockerCache {
        private boolean lock;
        private String column;
        private Field field;

        LockerCache(Boolean lock) {
            this.lock = lock;
        }

        LockerCache(Boolean lock, String column, Field field) {
            this.lock = lock;
            this.column = column;
            this.field = field;
        }
    }

    private static class TimestampTypeHandler
    implements VersionHandler<Timestamp> {
        private TimestampTypeHandler() {
        }

        @Override
        public void plusVersion(Object paramObj, Field field, Timestamp versionValue) throws Exception {
            field.set(paramObj, new Timestamp(new Date().getTime()));
        }
    }

    private static class DateTypeHandler
    implements VersionHandler<Date> {
        private DateTypeHandler() {
        }

        @Override
        public void plusVersion(Object paramObj, Field field, Date versionValue) throws Exception {
            field.set(paramObj, new Date());
        }
    }

    private static class LongTypeHandler
    implements VersionHandler<Long> {
        private LongTypeHandler() {
        }

        @Override
        public void plusVersion(Object paramObj, Field field, Long versionValue) throws Exception {
            field.set(paramObj, versionValue + 1L);
        }
    }

    private static class IntegerTypeHandler
    implements VersionHandler<Integer> {
        private IntegerTypeHandler() {
        }

        @Override
        public void plusVersion(Object paramObj, Field field, Integer versionValue) throws Exception {
            field.set(paramObj, versionValue + 1);
        }
    }

    private static class ShortTypeHandler
    implements VersionHandler<Short> {
        private ShortTypeHandler() {
        }

        @Override
        public void plusVersion(Object paramObj, Field field, Short versionValue) throws Exception {
            field.set(paramObj, (short)(versionValue + 1));
        }
    }
}

