/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common;

import com.baomidou.kisso.common.encrypt.Byte2Hex;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHashHelper {
    private static final Logger logger = LoggerFactory.getLogger(FileHashHelper.class);

    public static String getMD5Hash(String fileName) throws NoSuchAlgorithmException, IOException {
        return FileHashHelper.getHash(fileName, "MD5");
    }

    public static String getMD5Hash(InputStream ins) throws NoSuchAlgorithmException, IOException {
        return FileHashHelper.getHash(ins, "MD5");
    }

    public static String getHash(String pathName, String hashType) throws IOException, NoSuchAlgorithmException {
        File f = new File(pathName);
        logger.debug(" -------------------------------------------------------------------------------");
        logger.debug("|\u5f53\u524d\u6587\u4ef6\u540d\u79f0:" + f.getName());
        logger.debug("|\u5f53\u524d\u6587\u4ef6\u5927\u5c0f:" + f.length() / 1024L / 1024L + "MB");
        logger.debug("|\u5f53\u524d\u6587\u4ef6\u8def\u5f84[\u7edd\u5bf9]:" + f.getAbsolutePath());
        logger.debug("|\u5f53\u524d\u6587\u4ef6\u8def\u5f84[---]:" + f.getCanonicalPath());
        logger.debug("|\u5f53\u524d\u6587\u4ef6\u6700\u540e\u4e00\u6b21\u88ab\u4fee\u6539\u65f6\u95f4[---]:" + f.lastModified());
        logger.debug(" -------------------------------------------------------------------------------");
        return FileHashHelper.getHash(new FileInputStream(f), hashType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHash(InputStream ins, String hashType) throws IOException, NoSuchAlgorithmException {
        if (ins == null) {
            return null;
        }
        byte[] buffer = new byte[8192];
        MessageDigest md5 = MessageDigest.getInstance(hashType);
        try {
            int len;
            while ((len = ins.read(buffer)) != -1) {
                md5.update(buffer, 0, len);
            }
        }
        catch (Exception e) {
            logger.error("getHash error: ", (Throwable)e);
        }
        finally {
            ins.close();
        }
        return Byte2Hex.byte2Hex((byte[])md5.digest());
    }
}

