/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common.util;

public class HashUtil {
    static int M_MASK = -2023358767;
    static int M_SHIFT = 0;

    public static int additiveHash(String key, int prime) {
        int hash = key.length();
        for (int i = 0; i < key.length(); ++i) {
            hash += key.charAt(i);
        }
        return hash % prime;
    }

    public static int rotatingHash(String key, int prime) {
        int hash = key.length();
        for (int i = 0; i < key.length(); ++i) {
            hash = hash << 4 ^ hash >> 28 ^ key.charAt(i);
        }
        return hash % prime;
    }

    public static int oneByOneHash(String key) {
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash += key.charAt(i);
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static int bernstein(String key) {
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash = 33 * hash + key.charAt(i);
        }
        return hash;
    }

    public static int universal(char[] key, int mask, int[] tab) {
        int hash = key.length;
        int len = key.length;
        for (int i = 0; i < len << 3; i += 8) {
            char k = key[i >> 3];
            if ((k & '\u0001') == 0) {
                hash ^= tab[i + 0];
            }
            if ((k & 2) == 0) {
                hash ^= tab[i + 1];
            }
            if ((k & 4) == 0) {
                hash ^= tab[i + 2];
            }
            if ((k & 8) == 0) {
                hash ^= tab[i + 3];
            }
            if ((k & 0x10) == 0) {
                hash ^= tab[i + 4];
            }
            if ((k & 0x20) == 0) {
                hash ^= tab[i + 5];
            }
            if ((k & 0x40) == 0) {
                hash ^= tab[i + 6];
            }
            if ((k & 0x80) != 0) continue;
            hash ^= tab[i + 7];
        }
        return hash & mask;
    }

    public static int zobrist(char[] key, int mask, int[][] tab) {
        int hash = key.length;
        for (int i = 0; i < key.length; ++i) {
            hash ^= tab[i][key[i]];
        }
        return hash & mask;
    }

    public static int FNVHash(byte[] data) {
        int hash = -2128831035;
        for (byte b : data) {
            hash = hash * 16777619 ^ b;
        }
        if (M_SHIFT == 0) {
            return hash;
        }
        return (hash ^ hash >> M_SHIFT) & M_MASK;
    }

    public static int FNVHash1(byte[] data) {
        int p = 16777619;
        int hash = -2128831035;
        for (byte b : data) {
            hash = (hash ^ b) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return hash;
    }

    public static int FNVHash1(String data) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < data.length(); ++i) {
            hash = (hash ^ data.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return hash;
    }

    public static int intHash(int key) {
        key += ~(key << 15);
        key ^= key >>> 10;
        key += key << 3;
        key ^= key >>> 6;
        key += ~(key << 11);
        key ^= key >>> 16;
        return key;
    }

    public static int RSHash(String str) {
        int b = 378551;
        int a = 63689;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash = hash * a + str.charAt(i);
            a *= b;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int JSHash(String str) {
        int hash = 1315423911;
        for (int i = 0; i < str.length(); ++i) {
            hash ^= (hash << 5) + str.charAt(i) + (hash >> 2);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int PJWHash(String str) {
        int BitsInUnsignedInt = 32;
        int ThreeQuarters = BitsInUnsignedInt * 3 / 4;
        int OneEighth = BitsInUnsignedInt / 8;
        int HighBits = -1 << BitsInUnsignedInt - OneEighth;
        int hash = 0;
        int test = 0;
        for (int i = 0; i < str.length(); ++i) {
            test = (hash = (hash << OneEighth) + str.charAt(i)) & HighBits;
            if (test == 0) continue;
            hash = (hash ^ test >> ThreeQuarters) & ~HighBits;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int ELFHash(String str) {
        int hash = 0;
        int x = 0;
        for (int i = 0; i < str.length(); ++i) {
            x = (int)((long)(hash = (hash << 4) + str.charAt(i)) & 0xF0000000L);
            if (x == 0) continue;
            hash ^= x >> 24;
            hash &= ~x;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int BKDRHash(String str) {
        int seed = 131;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash = hash * seed + str.charAt(i);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int SDBMHash(String str) {
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash = str.charAt(i) + (hash << 6) + (hash << 16) - hash;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int DJBHash(String str) {
        int hash = 5381;
        for (int i = 0; i < str.length(); ++i) {
            hash = (hash << 5) + hash + str.charAt(i);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int DEKHash(String str) {
        int hash = str.length();
        for (int i = 0; i < str.length(); ++i) {
            hash = hash << 5 ^ hash >> 27 ^ str.charAt(i);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int APHash(String str) {
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash ^= (i & 1) == 0 ? hash << 7 ^ str.charAt(i) ^ hash >> 3 : ~(hash << 11 ^ str.charAt(i) ^ hash >> 5);
        }
        return hash;
    }

    public static int javaDefaultHash(String str) {
        int h = 0;
        int off = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + str.charAt(off++);
        }
        return h;
    }

    public static long mixHash(String str) {
        long hash = str.hashCode();
        hash <<= 32;
        return hash |= (long)HashUtil.FNVHash1(str);
    }
}

