/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.upload;

import com.baomidou.framework.common.SwConstants;
import com.baomidou.framework.upload.CosFile;
import com.baomidou.framework.upload.CosFileHeader;
import com.baomidou.framework.upload.CosFileRenamePolicy;
import com.baomidou.framework.upload.UploadCode;
import com.baomidou.framework.upload.cos.multipart.FilePart;
import com.baomidou.framework.upload.cos.multipart.FileRenamePolicy;
import com.baomidou.framework.upload.cos.multipart.MacBinaryDecoderOutputStream;
import com.baomidou.framework.upload.cos.multipart.MultipartParser;
import com.baomidou.framework.upload.cos.multipart.ParamPart;
import com.baomidou.framework.upload.cos.multipart.Part;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosMultipartRequest {
    protected Logger logger = LoggerFactory.getLogger(CosMultipartRequest.class);
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Hashtable files = new Hashtable();
    private HttpServletRequest request;
    private String saveDirectory;
    private int maxPostSize;
    private FileRenamePolicy fileRenamePolicy;
    private String fileHeaderExts = null;
    private String charset = SwConstants.UTF_8;

    protected CosMultipartRequest() {
    }

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory) {
        this(request, saveDirectory, 0x100000);
    }

    public CosMultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) {
        this.request = request;
        this.saveDirectory = saveDirectory;
        this.maxPostSize = maxPostSize;
    }

    public void upload() throws IOException {
        Part part;
        if (this.request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (this.saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (this.maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File dir = new File(this.saveDirectory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + this.saveDirectory);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + this.saveDirectory);
        }
        MultipartParser parser = new MultipartParser(this.request, this.maxPostSize, true, true, this.getCharset());
        HashMap<String, String> paramParts = new HashMap<String, String>();
        while ((part = parser.readNextPart()) != null) {
            String name = part.getName();
            if (name == null) {
                throw new IOException("Malformed input: parameter name missing (known Opera 7 bug)");
            }
            if (part.isFile()) {
                FilePart filePart = (FilePart)part;
                String fileName = filePart.getFileName();
                if (fileName != null) {
                    CosFile cfi = this.writeTo(dir, fileName, this.getFileRenamePolicy(), filePart);
                    cfi.setDir(dir.toString());
                    cfi.setOriginal(fileName);
                    cfi.setParamParts(paramParts);
                    this.files.put(name, cfi);
                    continue;
                }
                this.files.put(name, new CosFile());
                continue;
            }
            if (!part.isParam()) continue;
            ParamPart paramPart = (ParamPart)part;
            paramParts.put(paramPart.getName(), paramPart.getStringValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CosFile writeTo(File fileOrDirectory, String fileName, FileRenamePolicy policy, FilePart filePart) throws IOException {
        OutputStream fileOut = null;
        CosFile cf = new CosFile();
        try {
            if (fileName != null) {
                BufferedInputStream in = new BufferedInputStream(filePart.getInputStream());
                cf.setType(filePart.getContentType());
                if (StringUtils.isNotBlank((String)this.fileHeaderExts)) {
                    try {
                        byte[] data = new byte[3];
                        in.mark(3);
                        in.read(data, 0, data.length);
                        in.reset();
                        String fileExt = this.readFileExt(data, fileName);
                        if (fileExt == null) {
                            cf.setUploadCode(UploadCode.ILLEGAL_EXT);
                            this.logger.debug(" upload fileType is null.");
                            CosFile cosFile = cf;
                            return cosFile;
                        }
                        cf.setSuffix(fileExt);
                    }
                    catch (Exception e) {
                        this.logger.debug("upload file error. ", (Throwable)e);
                        cf.setUploadCode(UploadCode.EXCEPTION);
                        CosFile cosFile = cf;
                        return cosFile;
                    }
                } else {
                    cf.setSuffix(fileName.substring(fileName.lastIndexOf(".")));
                }
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, fileName) : fileOrDirectory;
                if (policy instanceof CosFileRenamePolicy) {
                    ((CosFileRenamePolicy)policy).setSuffix(cf.getSuffix());
                }
                if (policy != null) {
                    file = policy.rename(file);
                    fileName = file.getName();
                    cf.setFilename(fileName);
                }
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                cf.setSize(this.write(fileOut, filePart.getContentType(), in));
            }
        }
        catch (Exception e) {
            this.logger.debug("upload file write error. ", (Throwable)e);
            cf.setUploadCode(UploadCode.EXCEPTION);
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
        }
        return cf;
    }

    private String readFileExt(byte[] data, String fileName) throws Exception {
        String fileExt = fileName.substring(fileName.lastIndexOf("."));
        StringBuffer fe = new StringBuffer();
        fe.append(CosFileHeader.bytesToHexString(data));
        fe.append(fileExt);
        if (this.fileHeaderExts.contains(fe.toString())) {
            return fileExt;
        }
        return null;
    }

    private long write(OutputStream out, String contentType, InputStream in) throws IOException {
        int read;
        if (contentType.equals("application/x-macbinary")) {
            out = new MacBinaryDecoderOutputStream(out);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            size += (long)read;
        }
        return size;
    }

    public CosMultipartRequest(ServletRequest request, String saveDirectory) throws IOException {
        this((HttpServletRequest)request, saveDirectory);
    }

    public CosMultipartRequest(ServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this((HttpServletRequest)request, saveDirectory, maxPostSize);
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public CosFile getCosFile(String name) {
        try {
            return (CosFile)this.files.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getSaveDirectory() {
        return this.saveDirectory;
    }

    public FileRenamePolicy getFileRenamePolicy() {
        if (this.fileRenamePolicy == null) {
            return new CosFileRenamePolicy();
        }
        return this.fileRenamePolicy;
    }

    public void setFileRenamePolicy(FileRenamePolicy fileRenamePolicy) {
        this.fileRenamePolicy = fileRenamePolicy;
    }

    public String getFileHeaderExts() {
        return this.fileHeaderExts;
    }

    public void setFileHeaderExts(String fileHeaderExts) {
        this.fileHeaderExts = fileHeaderExts;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

