/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.upload.cos;

import com.baomidou.framework.upload.cos.Daemon;
import java.net.Socket;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public abstract class DaemonHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected int DEFAULT_PORT = 1313;
    private Thread daemonThread;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.daemonThread = new Daemon(this);
            this.daemonThread.start();
        }
        catch (Exception e) {
            this.log("Problem starting socket server daemon thread" + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    protected int getSocketPort() {
        try {
            return Integer.parseInt(this.getInitParameter("socketPort"));
        }
        catch (NumberFormatException e) {
            return this.DEFAULT_PORT;
        }
    }

    public abstract void handleClient(Socket var1);

    public void destroy() {
        try {
            this.daemonThread.stop();
            this.daemonThread = null;
        }
        catch (Exception e) {
            this.log("Problem stopping server socket daemon thread: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }
}

