/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import com.blade.jdbc.page.PageRow;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Sql2o;

public final class Base {
    private static final Logger log = LoggerFactory.getLogger(Base.class);
    public static final ThreadLocal<PageRow> pageLocal = new ThreadLocal();
    public static final ThreadLocal<Connection> connectionThreadLocal = new ThreadLocal();
    public static Sql2o sql2o;

    public static Sql2o open(String url, String user, String password) {
        sql2o = new Sql2o(url, user, password);
        log.info("\u2b22 Blade-JDBC initializing");
        return sql2o;
    }

    public static Sql2o open(DataSource dataSource) {
        sql2o = new Sql2o(dataSource);
        log.info("\u2b22 Blade-JDBC initializing");
        return sql2o;
    }

    public static Sql2o open(Sql2o sql2o_) {
        sql2o = sql2o_;
        log.info("\u2b22 Blade-JDBC initializing");
        return sql2o;
    }

    public static <T> T atomic(Supplier<T> supplier) {
        T result = null;
        try {
            Connection connection = sql2o.beginTransaction();
            connectionThreadLocal.set(connection);
            result = supplier.get();
            connection.commit();
        }
        catch (RuntimeException e) {
            log.warn("Transaction rollback");
            connectionThreadLocal.get().rollback();
            throw e;
        }
        finally {
            connectionThreadLocal.remove();
            return result;
        }
    }
}

