/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.core;

import com.blade.jdbc.Base;
import com.blade.jdbc.annotation.Table;
import com.blade.jdbc.annotation.Transient;
import com.blade.jdbc.core.ConditionEnum;
import com.blade.jdbc.core.QueryMeta;
import com.blade.jdbc.core.SqlBuilder;
import com.blade.jdbc.core.WhereParam;
import com.blade.jdbc.page.Page;
import com.blade.jdbc.page.PageRow;
import com.blade.jdbc.utils.Unchecked;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Query;
import org.sql2o.Sql2o;

public class ActiveRecord
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ActiveRecord.class);
    @Transient
    protected Sql2o sql2o;
    @Transient
    Set<WhereParam> whereValues = new LinkedHashSet<WhereParam>();
    @Transient
    private Set<String> saveOrUpdateProperties = new TreeSet<String>();

    public Sql2o getSql2o() {
        if (null != this.sql2o) {
            return this.sql2o;
        }
        return Base.sql2o;
    }

    public <T extends ActiveRecord> T where(String key, Object value) {
        return this.where(key, "=", value);
    }

    public <T extends ActiveRecord> T where(String key, String opt, Object value) {
        this.whereValues.add(WhereParam.builder().key(key).opt(opt).value(value).build());
        this.saveOrUpdateProperties.add(key);
        return (T)this;
    }

    public <T extends ActiveRecord> T like(String key, Object value) {
        return this.where(key, "LIKE", value);
    }

    public <T extends ActiveRecord> T and(String key, Object value) {
        return this.where(key, value);
    }

    public <T extends ActiveRecord> T and(String key, String opt, Object value) {
        return this.where(key, opt, value);
    }

    public <T extends ActiveRecord> T or(String key, Object value) {
        return this.or(key, "=", value);
    }

    public <T extends ActiveRecord> T or(String key, String opt, Object value) {
        return this.where(" OR " + key, opt, value);
    }

    public <T extends ActiveRecord> T in(String key, List<?> args) {
        return this.where(key, "IN", args);
    }

    public <S extends Serializable> S save() {
        QueryMeta queryMeta = SqlBuilder.buildInsertSql(this);
        try (Connection con = this.getConn();){
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            Query query = con.createQuery(queryMeta.getSql()).bind((Object)this);
            Serializable serializable = (Serializable)query.executeUpdate().getKey();
            return (S)serializable;
        }
    }

    public int update(Serializable pk) {
        return this.update(this.getPk(), pk);
    }

    public int update(String field, Object value) {
        this.whereValues.add(WhereParam.builder().key(field).opt("=").value(value).build());
        return this.update();
    }

    public int update() {
        QueryMeta queryMeta = SqlBuilder.buildUpdateSql(this);
        int result = this.invoke(queryMeta);
        this.cleanParam();
        return result;
    }

    public int execute(String sql, Object ... params) {
        int pos = 1;
        while (sql.contains("?")) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        return this.invoke(new QueryMeta(sql, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invoke(QueryMeta queryMeta) {
        log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
        log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
        Connection con = this.getConn();
        try {
            Query query = con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams());
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            int n = query.executeUpdate().getResult();
            return n;
        }
        finally {
            if (Base.connectionThreadLocal.get() == null && null != con) {
                con.close();
            }
        }
    }

    private Connection getConn() {
        Connection connection = Base.connectionThreadLocal.get();
        if (null != connection) {
            return connection;
        }
        return this.getSql2o().open();
    }

    public <T extends ActiveRecord> T query(String sql, Object ... args) {
        return (T)((ActiveRecord)this.query(this.getClass(), sql, args));
    }

    public <T> T query(Class<T> type, String sql, Object ... args) {
        int pos = 1;
        while (sql.indexOf("?") != -1) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        try (Connection con = this.getSql2o().open();){
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(args));
            this.cleanParam();
            Query query = con.createQuery(sql).withParams(args).throwOnMappingFailure(false);
            QueryMeta queryMeta = SqlBuilder.buildFindAllSql(this, null);
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            Object object = query.executeAndFetchFirst(type);
            return (T)object;
        }
    }

    public <T extends ActiveRecord> List<T> queryAll(String sql, Object ... args) {
        return this.queryAll(this.getClass(), sql, args);
    }

    public <T> List<T> queryAll(Class<T> type, String sql, Object ... args) {
        int pos = 1;
        while (sql.indexOf("?") != -1) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        PageRow pageRow = Base.pageLocal.get();
        String limit = SqlBuilder.appendLimit(pageRow);
        if (null != limit) {
            sql = sql + limit;
        }
        args = args == null ? new Object[]{} : args;
        try (Connection con = this.getSql2o().open();){
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(args));
            this.cleanParam();
            Query query = con.createQuery(sql).withParams(args).throwOnMappingFailure(false);
            QueryMeta queryMeta = SqlBuilder.buildFindAllSql(this, null);
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            List list = query.executeAndFetch(type);
            return list;
        }
    }

    public <T extends ActiveRecord> List<T> findAll() {
        return this.findAll(null);
    }

    public <T> List<T> findAll(Class<T> type, Supplier<ConditionEnum> ... conditions) {
        QueryMeta queryMeta = SqlBuilder.buildFindAllSql(this, conditions);
        try (Connection con = this.getSql2o().open();){
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
            this.cleanParam();
            Query query = con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams()).throwOnMappingFailure(false);
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            List list = query.executeAndFetch(type);
            return list;
        }
    }

    public <T extends ActiveRecord> List<T> findAll(Supplier<ConditionEnum> ... conditions) {
        return this.findAll(this.getClass(), conditions);
    }

    public <T extends ActiveRecord> Page<T> page(int page, int limit) {
        return this.page(page, limit, null);
    }

    public <T extends ActiveRecord> Page<T> page(int page, int limit, String orderBy) {
        return this.page(new PageRow(page, limit), orderBy);
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow) {
        return this.page(pageRow, null);
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow, String orderBy) {
        QueryMeta queryMeta = SqlBuilder.buildFindAllSql(this, null);
        return this.page(pageRow, queryMeta.getSql(), orderBy, queryMeta.getParams());
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow, String sql, Object ... params) {
        return this.page(pageRow, sql, null, params);
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow, String sql, String orderBy, Object ... params) {
        Base.pageLocal.set(pageRow);
        int page = pageRow.getPage();
        int limit = pageRow.getLimit();
        if (null != sql) {
            int pos = 1;
            while (sql.indexOf("?") != -1) {
                sql = sql.replaceFirst("\\?", ":p" + pos++);
            }
        } else {
            sql = "SELECT * FROM " + this.getTableName();
        }
        String countSql = "SELECT COUNT(0) FROM (" + sql + ") tmp";
        long count = this.count(countSql, params);
        if (null != orderBy) {
            sql = sql + " ORDER BY " + orderBy;
        }
        List<T> list = this.queryAll(sql, params);
        Page<T> pageBean = new Page<T>(count, page, limit);
        pageBean.setRows(list);
        Base.pageLocal.remove();
        return pageBean;
    }

    public <T extends ActiveRecord> T find() {
        QueryMeta queryMeta = SqlBuilder.buildFindSql(this);
        Class<?> type = this.getClass();
        try (Connection con = this.getSql2o().open();){
            this.cleanParam();
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
            Query query = con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams()).throwOnMappingFailure(false);
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            ActiveRecord activeRecord = (ActiveRecord)query.executeAndFetchFirst(type);
            return (T)activeRecord;
        }
    }

    public <T> T find(Class<T> type, Serializable id) {
        String sql = "SELECT * FROM " + this.getTableName() + " WHERE " + this.getPk() + " = :p1";
        QueryMeta queryMeta = new QueryMeta();
        SqlBuilder.mapping(queryMeta, this.getClass());
        try (Connection con = this.getSql2o().open();){
            this.cleanParam();
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => [{}]", (Object)id);
            Query query = con.createQuery(sql).withParams(new Object[]{id}).throwOnMappingFailure(false);
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            Object object = query.executeAndFetchFirst(type);
            return (T)object;
        }
    }

    public <T extends ActiveRecord> T find(Serializable id) {
        return (T)((ActiveRecord)this.find(this.getClass(), id));
    }

    private long count(boolean cleanParam) {
        QueryMeta queryMeta = SqlBuilder.buildCountSql(this);
        try (Connection con = this.getSql2o().open();){
            if (cleanParam) {
                this.cleanParam();
            }
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
            long l = (Long)con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams()).executeAndFetchFirst(Long.class);
            return l;
        }
    }

    public long count() {
        return this.count(true);
    }

    public long count(String sql, Object ... args) {
        int pos = 1;
        while (sql.indexOf("?") != -1) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        args = args == null ? new Object[]{} : args;
        try (Connection con = this.getSql2o().open();){
            this.cleanParam();
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(args));
            long l = (Long)con.createQuery(sql).withParams(args).executeAndFetchFirst(Long.class);
            return l;
        }
    }

    String getTableName() {
        Class<?> modelType = this.getClass();
        Table table = modelType.getAnnotation(Table.class);
        if (null != table) {
            return table.value();
        }
        return modelType.getSimpleName();
    }

    private String getPk() {
        Class<?> modelType = this.getClass();
        Table table = modelType.getAnnotation(Table.class);
        if (null != table) {
            return table.pk();
        }
        return "id";
    }

    public int delete() {
        QueryMeta queryMeta = SqlBuilder.buildDeleteSql(this);
        int result = this.invoke(queryMeta);
        this.cleanParam();
        return result;
    }

    public int delete(Serializable pk) {
        return this.delete(this.getPk(), pk);
    }

    public int delete(String field, Object value) {
        this.whereValues.add(WhereParam.builder().key(field).opt("=").value(value).build());
        return this.delete();
    }

    private void cleanParam() {
        this.whereValues.clear();
        this.saveOrUpdateProperties.clear();
        Stream.of(this.getClass().getDeclaredFields()).filter(field -> Objects.isNull(field.getAnnotation(Transient.class))).forEach(field -> Unchecked.wrap(() -> {
            field.setAccessible(true);
            field.set(this, null);
            return null;
        }));
    }

    public void setSql2o(Sql2o sql2o) {
        this.sql2o = sql2o;
    }
}

