/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.utils;

import com.blade.jdbc.utils.StringUtils;
import com.blade.jdbc.utils.UUIDUtils;

public class NameUtils {
    public static String getFirstUpperName(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        String firstChar = name.substring(0, 1).toUpperCase();
        return firstChar + name.substring(1);
    }

    public static String getFirstLowerName(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        String firstChar = name.substring(0, 1).toLowerCase();
        return firstChar + name.substring(1);
    }

    public static String getCamelName(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        name = name.toLowerCase();
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        while (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                sb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getUnderlineName(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i > 0 && Character.isUpperCase(c)) {
                sb.append("_");
            }
            sb.append(c);
        }
        return sb.toString().toLowerCase();
    }

    public static String createUniqueFileName(String fileName) {
        int index = fileName.lastIndexOf(".");
        String suffix = fileName.substring(index);
        String uqName = UUIDUtils.getUUID16() + suffix;
        return uqName;
    }

    public static String createEndSuffixFileName(String fileName, String endSuffix) {
        int index = fileName.lastIndexOf(".");
        String preFileName = fileName.substring(0, index);
        String suffix = fileName.substring(index);
        return preFileName + endSuffix + suffix;
    }
}

