/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.kit.Assert;
import com.blade.kit.DateKit;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.Response;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.ui.template.TemplateEngine;
import com.blade.server.netty.ProgressiveFutureListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponse
implements Response {
    private static final Logger log = LoggerFactory.getLogger(HttpResponse.class);
    private String contentType = "text/html; charset=UTF-8";
    private HttpHeaders headers = new DefaultHttpHeaders();
    private Set<io.netty.handler.codec.http.cookie.Cookie> cookies = new HashSet<io.netty.handler.codec.http.cookie.Cookie>();
    private int statusCode = 200;
    private boolean isCommit = false;
    private ChannelHandlerContext ctx = null;
    private TemplateEngine templateEngine = null;

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public Response status(int status) {
        this.statusCode = status;
        return this;
    }

    @Override
    public Response contentType(@NonNull String contentType) {
        if (contentType == null) {
            throw new NullPointerException("contentType");
        }
        this.contentType = contentType;
        return this;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public Map<String, String> headers() {
        HashMap<String, String> map = new HashMap<String, String>(this.headers.size());
        this.headers.forEach(header -> {
            String cfr_ignored_0 = (String)map.put((String)header.getKey(), (String)header.getValue());
        });
        return map;
    }

    @Override
    public Response header(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.headers.set(name, (Object)value);
        return this;
    }

    @Override
    public Response cookie(@NonNull Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        DefaultCookie nettyCookie = new DefaultCookie(cookie.name(), cookie.value());
        if (cookie.domain() != null) {
            nettyCookie.setDomain(cookie.domain());
        }
        if (cookie.maxAge() > 0L) {
            nettyCookie.setMaxAge(cookie.maxAge());
        }
        nettyCookie.setPath(cookie.path());
        nettyCookie.setHttpOnly(cookie.httpOnly());
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(String name, String value) {
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)new io.netty.handler.codec.http.cookie.DefaultCookie(name, value));
        return this;
    }

    @Override
    public Response cookie(@NonNull String name, @NonNull String value, int maxAge) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setPath("/");
        nettyCookie.setMaxAge((long)maxAge);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(@NonNull String name, @NonNull String value, int maxAge, boolean secured) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setPath("/");
        nettyCookie.setMaxAge((long)maxAge);
        nettyCookie.setSecure(secured);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(@NonNull String path, @NonNull String name, @NonNull String value, int maxAge, boolean secured) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setMaxAge((long)maxAge);
        nettyCookie.setSecure(secured);
        nettyCookie.setPath(path);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response removeCookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<io.netty.handler.codec.http.cookie.Cookie> cookieOpt = this.cookies.stream().filter(cookie -> cookie.name().equals(name)).findFirst();
        cookieOpt.ifPresent(cookie -> {
            cookie.setValue("");
            cookie.setMaxAge(-1L);
        });
        return this;
    }

    @Override
    public Map<String, String> cookies() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.cookies.forEach(cookie -> map.put(cookie.name(), cookie.value()));
        return map;
    }

    @Override
    public void download(@NonNull String fileName, @NonNull File file) throws Exception {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (null == file || !file.exists() || !file.isFile()) {
            Assert.throwException("please check the file is effective!");
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        long fileLength = raf.length();
        this.contentType = StringKit.mimeType(file.getName());
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders httpHeaders = httpResponse.headers().add(this.getDefaultHeader());
        boolean keepAlive = WebContext.request().keepAlive();
        if (keepAlive) {
            httpResponse.headers().set("Connection", (Object)"keep-alive");
        }
        httpHeaders.set("Content-Type", (Object)this.contentType);
        httpHeaders.set("Content-Disposition", (Object)("attachment; filename=" + new String(fileName.getBytes("UTF-8"), "ISO8859_1")));
        httpHeaders.set("Content-Length", (Object)fileLength);
        this.ctx.write((Object)httpResponse);
        ChannelFuture sendFileFuture = this.ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)this.ctx.newProgressivePromise());
        ChannelFuture lastContentFuture = this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        sendFileFuture.addListener((GenericFutureListener)ProgressiveFutureListener.build(raf));
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.isCommit = true;
    }

    @Override
    public void render(@NonNull ModelAndView modelAndView) {
        if (modelAndView == null) {
            throw new NullPointerException("modelAndView");
        }
        StringWriter sw = new StringWriter();
        try {
            this.templateEngine.render(modelAndView, sw);
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])sw.toString().getBytes());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode), buffer);
            this.send((FullHttpResponse)response);
        }
        catch (Exception e) {
            log.error("render error", (Throwable)e);
        }
    }

    @Override
    public void redirect(@NonNull String newUri) {
        if (newUri == null) {
            throw new NullPointerException("newUri");
        }
        this.headers.set("Location", (Object)newUri);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        this.send((FullHttpResponse)response);
    }

    @Override
    public boolean isCommit() {
        return this.isCommit;
    }

    @Override
    public void send(@NonNull FullHttpResponse response) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        response.headers().add(this.getDefaultHeader());
        boolean keepAlive = WebContext.request().keepAlive();
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
        if (!keepAlive) {
            this.ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set("Connection", (Object)HttpHeaderValues.KEEP_ALIVE);
            this.ctx.write((Object)response);
        }
        this.isCommit = true;
    }

    private HttpHeaders getDefaultHeader() {
        this.headers.set("Date", (Object)DateKit.gmtDate());
        this.headers.set("Content-Type", (Object)this.contentType);
        this.headers.set("Server", (Object)"blade/2.0.1-alpha2");
        this.cookies.forEach(cookie -> this.headers.add("Set-Cookie", (Object)ServerCookieEncoder.LAX.encode(cookie)));
        return this.headers;
    }

    public static HttpResponse build(ChannelHandlerContext ctx, TemplateEngine templateEngine) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.templateEngine = templateEngine;
        httpResponse.ctx = ctx;
        return httpResponse;
    }
}

