/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.ui;

import java.util.List;

public class HtmlCreator {
    private StringBuilder html = new StringBuilder();

    public HtmlCreator() {
        this.html.append("<!DOCTYPE html>");
        this.html.append("<head>");
        this.html.append("<meta charset=\"utf-8\">");
        this.html.append("<style type='text/css'>.version{padding:10px;text-decoration-line: none;}</style>");
    }

    public HtmlCreator title(String title) {
        this.html.append("<title>").append(title).append("</title>");
        return this;
    }

    public HtmlCreator h1(String heading) {
        this.html.append("</head>");
        this.html.append("<body>");
        this.html.append("<h1>").append(heading).append("</h1>");
        return this;
    }

    public HtmlCreator h2(String heading) {
        this.html.append("<h2>").append(heading).append("</h2>");
        return this;
    }

    public HtmlCreator paragraph(String paragraph) {
        this.html.append("<p>").append(paragraph).append("</p>");
        return this;
    }

    public HtmlCreator startP() {
        this.html.append("<p>");
        return this;
    }

    public HtmlCreator addBold(String text) {
        this.html.append("<b>").append(text).append("</b>");
        return this;
    }

    public HtmlCreator endP() {
        this.html.append("</p>");
        return this;
    }

    public HtmlCreator hr() {
        this.html.append("<hr/>");
        return this;
    }

    public HtmlCreator br() {
        this.html.append("<br/>");
        return this;
    }

    public HtmlCreator addTableWithHeaders(List<String> headers) {
        this.html.append("<table>");
        this.html.append("<tr>");
        headers.forEach(h -> this.html.append("<th>").append((String)h).append("</th>"));
        this.html.append("</tr>");
        return this;
    }

    public HtmlCreator addRowToTable(List<String> rowElements) {
        this.html.append("<tr>");
        rowElements.forEach(re -> this.html.append("<td>").append((String)re).append("</td>"));
        this.html.append("</tr>");
        return this;
    }

    public HtmlCreator endTable() {
        this.html.append("</table>");
        return this;
    }

    public HtmlCreator startStyle() {
        this.html.append("<style type='text/css'>");
        return this;
    }

    public HtmlCreator endStyle() {
        this.html.append("</style>");
        return this;
    }

    public HtmlCreator centerHeadings() {
        this.html.append("h1, h2 { text-align: center; }");
        return this;
    }

    public HtmlCreator add(String text) {
        this.html.append(text);
        return this;
    }

    public HtmlCreator styleTables() {
        this.html.append("table, th, td { margin: 0 auto; border: 1px solid black; border-collapse: collapse; text-align: center; }");
        return this;
    }

    public HtmlCreator center(String text) {
        this.html.append("<center>").append(text).append("</center>");
        return this;
    }

    public String toString() {
        return this.html.toString();
    }

    public String html() {
        this.html.append("<hr/><br/><p><center><a href='https://github.com/biezhi/blade' target='_blank'>Blade-2.0.1-alpha2</a></center></p>");
        this.html.append("</body>");
        return this.html.toString();
    }
}

