/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.exception.BladeException;
import com.blade.exception.ExceptionResolve;
import com.blade.kit.BladeKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.RouteViewResolve;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.HttpRequest;
import com.blade.mvc.http.HttpResponse;
import com.blade.mvc.http.Response;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.RouteHandler;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.DefaultUI;
import com.blade.server.netty.SessionHandler;
import com.blade.server.netty.StaticFileHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    private final Blade blade;
    private final RouteMatcher routeMatcher;
    private final Set<String> statics;
    private final Optional<String> page404;
    private final Optional<String> page500;
    private final SessionHandler sessionHandler;
    private final StaticFileHandler staticFileHandler;
    private final RouteViewResolve routeViewResolve;
    private final ExceptionResolve exceptionResolve;

    HttpServerHandler(Blade blade, ExceptionResolve exceptionResolve) {
        this.blade = blade;
        this.statics = blade.getStatics();
        this.exceptionResolve = exceptionResolve;
        this.page404 = Optional.ofNullable(blade.environment().get("mvc.view.404", null));
        this.page500 = Optional.ofNullable(blade.environment().get("mvc.view.500", null));
        this.routeMatcher = blade.routeMatcher();
        this.routeViewResolve = new RouteViewResolve(blade);
        this.staticFileHandler = new StaticFileHandler(blade);
        this.sessionHandler = blade.sessionManager() != null ? new SessionHandler(blade) : null;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) throws Exception {
        block17: {
            if (HttpUtil.is100ContinueExpected((HttpMessage)fullHttpRequest)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            HttpRequest request = HttpRequest.build(ctx, fullHttpRequest, this.sessionHandler);
            HttpResponse response = HttpResponse.build(ctx, this.blade.templateEngine());
            Signature signature = Signature.builder().request(request).response(response).build();
            try {
                String uri = request.uri();
                log.debug("{}\t{}\t{}", new Object[]{request.protocol(), request.method(), uri});
                WebContext.set(new WebContext(request, response));
                if (this.isStaticFile(uri)) {
                    this.staticFileHandler.handle(ctx, request, response);
                    return;
                }
                Route route = this.routeMatcher.lookupRoute(request.method(), uri);
                if (null == route) {
                    response.notFound();
                    if (this.page404.isPresent()) {
                        response.render(this.page404.get());
                    } else {
                        String html = String.format(DefaultUI.VIEW_404, uri);
                        response.html(html);
                    }
                    return;
                }
                request.initPathParams(route);
                signature.setRoute(route);
                if (!this.invokeMiddleware(this.routeMatcher.getMiddleware(), signature)) {
                    this.sendFinish(response);
                    return;
                }
                if (!this.invokeHook(this.routeMatcher.getBefore(uri), signature)) {
                    this.sendFinish(response);
                    return;
                }
                signature.setRoute(route);
                this.routeHandle(signature);
                this.invokeHook(this.routeMatcher.getAfter(uri), signature);
            }
            catch (Exception e) {
                if (null != this.exceptionResolve && !this.exceptionResolve.handle(e, signature)) {
                    break block17;
                }
                throw e;
            }
            finally {
                this.sendFinish(response);
                WebContext.remove();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("error", cause);
        if (!ctx.channel().isActive()) {
            ctx.close();
            return;
        }
        Response response = WebContext.response();
        String error = cause.getMessage();
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        if (this.page500.isPresent()) {
            cause.printStackTrace(writer);
            WebContext.request().attribute("err_message", error);
            WebContext.request().attribute("err_stackTrace", sw.toString());
            response.render(this.page500.get());
        } else if (this.blade.devMode()) {
            writer.write(String.format(DefaultUI.ERROR_START, cause.getClass() + " : " + cause.getMessage()));
            writer.write("\r\n");
            cause.printStackTrace(writer);
            writer.println("<hr/><br/><p><center><a href='https://github.com/biezhi/blade' target='_blank'>Blade-2.0.1-alpha2</a></center></p>");
            error = sw.toString();
            response.html(error);
        } else {
            response.body("Internal Server Error");
        }
    }

    private boolean isStaticFile(String uri) {
        Optional<String> result = this.statics.stream().filter(s -> s.equals(uri) || uri.startsWith((String)s)).findFirst();
        return result.isPresent();
    }

    private boolean routeHandle(Signature signature) throws Exception {
        Object target = signature.getRoute().getTarget();
        if (null == target) {
            Class<?> clazz = signature.getAction().getDeclaringClass();
            target = this.blade.getBean(clazz);
            signature.getRoute().setTarget(target);
        }
        if (signature.getRoute().getTargetType() == RouteHandler.class) {
            RouteHandler routeHandler = (RouteHandler)target;
            routeHandler.handle(signature.request(), signature.response());
            return false;
        }
        return this.routeViewResolve.handle(signature);
    }

    private boolean invokeMiddleware(List<Route> middleware, Signature signature) throws BladeException {
        if (BladeKit.isEmpty(middleware)) {
            return true;
        }
        for (Route route : middleware) {
            WebHook webHook = (WebHook)route.getTarget();
            boolean flag = webHook.before(signature);
            if (flag) continue;
            return false;
        }
        return true;
    }

    private boolean invokeHook(List<Route> hooks, Signature signature) throws BladeException {
        for (Route route : hooks) {
            if (route.getTargetType() == RouteHandler.class) {
                RouteHandler routeHandler = (RouteHandler)route.getTarget();
                routeHandler.handle(signature.request(), signature.response());
                continue;
            }
            boolean flag = this.routeViewResolve.invokeHook(signature, route);
            if (flag) continue;
            return false;
        }
        return true;
    }

    private void sendFinish(Response response) {
        if (!response.isCommit()) {
            response.body(Unpooled.EMPTY_BUFFER);
        }
    }
}

