/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import com.blade.kit.IOKit;
import com.blade.kit.ReflectKit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger log = LoggerFactory.getLogger(Environment.class);
    private static final String PREFIX_CLASSPATH = "classpath:";
    private static final String PREFIX_FILE = "file:";
    private static final String PREFIX_URL = "url:";
    private Properties props = new Properties();

    public static Environment empty() {
        return new Environment();
    }

    public static Environment of(@NonNull Properties props) {
        if (props == null) {
            throw new NullPointerException("props");
        }
        Environment environment = new Environment();
        environment.props = props;
        return environment;
    }

    public static Environment of(@NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        Environment environment = new Environment();
        map.forEach((key, value) -> environment.props.setProperty((String)key, (String)value));
        return environment;
    }

    public static Environment of(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        try {
            return Environment.of(url.openStream());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    public static Environment of(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            return Environment.of(Files.newInputStream(Paths.get(file.getPath(), new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Environment of(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (location.startsWith(PREFIX_CLASSPATH)) {
            location = location.substring(PREFIX_CLASSPATH.length());
            return Environment.loadClasspath(location);
        }
        if (location.startsWith(PREFIX_FILE)) {
            location = location.substring(PREFIX_FILE.length());
            return Environment.of(new File(location));
        }
        if (location.startsWith(PREFIX_URL)) {
            location = location.substring(PREFIX_URL.length());
            try {
                return Environment.of(new URL(location));
            }
            catch (MalformedURLException e) {
                log.error("", (Throwable)e);
                return null;
            }
        }
        return Environment.loadClasspath(location);
    }

    private static Environment loadClasspath(@NonNull String classpath) {
        InputStream is;
        if (classpath == null) {
            throw new NullPointerException("classpath");
        }
        String path = classpath;
        if (classpath.startsWith("/")) {
            path = classpath.substring(1);
        }
        if (null == (is = Environment.getDefault().getResourceAsStream(path))) {
            return new Environment();
        }
        return Environment.of(is);
    }

    private static Environment of(@NonNull InputStream is) {
        if (is == null) {
            throw new NullPointerException("is");
        }
        try {
            Environment environment = new Environment();
            environment.props.load(new InputStreamReader(is, "UTF-8"));
            Environment environment2 = environment;
            return environment2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOKit.closeQuietly(is);
        }
    }

    public static ClassLoader getDefault() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null && (loader = Environment.class.getClassLoader()) == null) {
            try {
                loader = ClassLoader.getSystemClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return loader;
    }

    public Environment set(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        String val = value.toString();
        this.props.put(key, val);
        return this;
    }

    public Environment add(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.set(key, value);
    }

    public Environment addAll(@NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        map.forEach((key, value) -> this.props.setProperty((String)key, (String)value));
        return this;
    }

    public Environment addAll(@NonNull Properties props) {
        if (props == null) {
            throw new NullPointerException("props");
        }
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.props.setProperty(key.toString(), value.toString())));
        return this;
    }

    public Optional<String> get(String key) {
        if (null == key) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.props.getProperty(key));
    }

    public String getOrNull(String key) {
        return this.get(key).orElse(null);
    }

    public String get(String key, String defaultValue) {
        return this.get(key).orElse(defaultValue);
    }

    public Optional<Object> getObject(String key) {
        return Optional.ofNullable(this.props.get(key));
    }

    public Optional<Integer> getInt(String key) {
        if (null != key && this.getObject(key).isPresent()) {
            return Optional.of(Integer.parseInt(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Integer getIntOrNull(String key) {
        Optional<Integer> intVal = this.getInt(key);
        return intVal.orElse(null);
    }

    public Integer getInt(String key, int defaultValue) {
        if (this.getInt(key).isPresent()) {
            return this.getInt(key).get();
        }
        return defaultValue;
    }

    public Optional<Long> getLong(String key) {
        if (null != key && this.getObject(key).isPresent()) {
            return Optional.of(Long.parseLong(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Long getLongOrNull(String key) {
        Optional<Long> longVal = this.getLong(key);
        return longVal.orElse(null);
    }

    public Long getLong(String key, long defaultValue) {
        return this.getLong(key).orElse(defaultValue);
    }

    public Optional<Boolean> getBoolean(String key) {
        if (null != key && this.getObject(key).isPresent()) {
            return Optional.of(Boolean.parseBoolean(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Boolean getBooleanOrNull(String key) {
        Optional<Boolean> boolVal = this.getBoolean(key);
        return boolVal.orElse(null);
    }

    public Boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key).orElse(defaultValue);
    }

    public Optional<Double> getDouble(String key) {
        if (null != key && this.getObject(key).isPresent()) {
            return Optional.of(Double.parseDouble(this.getObject(key).get().toString()));
        }
        return Optional.empty();
    }

    public Double getDoubleOrNull(String key) {
        Optional<Double> doubleVal = this.getDouble(key);
        return doubleVal.orElse(null);
    }

    public Double getDouble(String key, double defaultValue) {
        return this.getDouble(key).orElse(defaultValue);
    }

    public Optional<Date> getDate(String key) {
        if (null != key && this.getObject(key).isPresent()) {
            String value = this.getObject(key).get().toString();
            Date date = (Date)ReflectKit.convert(Date.class, value);
            return Optional.ofNullable(date);
        }
        return Optional.empty();
    }

    public Date getDateOrNull(String key) {
        Optional<Date> dateVal = this.getDate(key);
        return dateVal.orElse(null);
    }

    public Map<String, Object> getPrefix(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != key) {
            this.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key_, value) -> {
                if (key_.toString().startsWith(key)) {
                    map.put(key_.toString().substring(key.length() + 1), value);
                }
            }));
        }
        return map;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.props.size());
        this.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
        return map;
    }

    public boolean hasKey(String key) {
        if (null == key) {
            return false;
        }
        return this.props.containsKey(key);
    }

    public boolean hasValue(String value) {
        return this.props.containsValue(value);
    }

    public Properties props() {
        return this.props;
    }

    public int size() {
        return this.props.size();
    }

    private Environment() {
    }
}

