/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc;

import com.blade.ioc.Ioc;
import com.blade.ioc.bean.BeanDefine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIoc
implements Ioc {
    private static final Logger log = LoggerFactory.getLogger(SimpleIoc.class);
    private final Map<String, BeanDefine> pool = new HashMap<String, BeanDefine>(32);

    @Override
    public void addBean(Object bean) {
        this.addBean(bean.getClass().getName(), bean);
    }

    @Override
    public void addBean(String name, Object bean) {
        BeanDefine beanDefine = new BeanDefine(bean);
        this.addBean(name, beanDefine);
        Class<?>[] interfaces = beanDefine.getType().getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> interfaceClazz : interfaces) {
                this.addBean(interfaceClazz.getName(), beanDefine);
            }
        }
    }

    @Override
    public void setBean(Class<?> type, Object proxyBean) {
        BeanDefine beanDefine = this.pool.get(type.getName());
        if (beanDefine != null) {
            beanDefine.setBean(proxyBean);
        } else {
            beanDefine = new BeanDefine(proxyBean, type);
        }
        this.pool.put(type.getName(), beanDefine);
    }

    @Override
    public <T> T addBean(Class<T> type) {
        Object bean = this.addBean(type, true);
        return type.cast(bean);
    }

    @Override
    public <T> T getBean(Class<T> type) {
        Object bean = this.getBean(type.getName());
        try {
            return type.cast(bean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getBean(String name) {
        BeanDefine beanDefine = this.pool.get(name);
        if (beanDefine == null) {
            return null;
        }
        return beanDefine.getBean();
    }

    @Override
    public List<BeanDefine> getBeanDefines() {
        return new ArrayList<BeanDefine>(this.pool.values());
    }

    @Override
    public BeanDefine getBeanDefine(Class<?> type) {
        return this.getBeanDefine(type, true);
    }

    @Override
    public List<Object> getBeans() {
        Set<String> beanNames = this.getBeanNames();
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.size());
        for (String beanName : beanNames) {
            Object bean = this.getBean(beanName);
            if (null == bean) continue;
            beans.add(bean);
        }
        return beans;
    }

    @Override
    public Set<String> getBeanNames() {
        return this.pool.keySet();
    }

    @Override
    public void remove(String beanName) {
        this.pool.remove(beanName);
    }

    @Override
    public void remove(Class<?> type) {
        this.pool.remove(type.getSimpleName());
    }

    @Override
    public void clearAll() {
        this.pool.clear();
    }

    private void addBean(String name, BeanDefine beanDefine) {
        if (this.pool.put(name, beanDefine) != null) {
            log.warn("Duplicated Bean: {}", (Object)name);
        }
    }

    private Object addBean(Class<?> type, boolean singleton) {
        return this.addBean(type.getName(), type, singleton);
    }

    private Object addBean(String name, Class<?> beanClass, boolean singleton) {
        Class<?>[] interfaces;
        BeanDefine beanDefine = this.getBeanDefine(beanClass, singleton);
        if (this.pool.put(name, beanDefine) != null) {
            log.warn("Duplicated Bean: {}", (Object)name);
        }
        if ((interfaces = beanClass.getInterfaces()).length > 0) {
            for (Class<?> interfaceClazz : interfaces) {
                if (null != this.getBean(interfaceClazz)) break;
                this.addBean(interfaceClazz.getName(), beanDefine);
            }
        }
        return beanDefine.getBean();
    }

    private BeanDefine getBeanDefine(Class<?> beanClass, boolean singleton) {
        try {
            Object object = beanClass.newInstance();
            return new BeanDefine(object, beanClass, singleton);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

