/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc.reader;

import com.blade.ioc.ClassReader;
import com.blade.ioc.bean.ClassInfo;
import com.blade.ioc.reader.AbstractClassReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarReaderImpl
extends AbstractClassReader
implements ClassReader {
    private static final Logger log = LoggerFactory.getLogger(JarReaderImpl.class);
    private static final String JAR_FILE = "jar:file:";
    private static final String WSJAR_FILE = "wsjar:file:";

    @Override
    public Set<ClassInfo> getClassByAnnotation(String packageName, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive) {
        HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = this.getClass().getClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                Set<ClassInfo> subClasses = this.getClasses(url, packageDirName, packageName, parent, annotation, recursive, classes);
                if (subClasses.size() <= 0) continue;
                classes.addAll(subClasses);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return classes;
    }

    private Set<ClassInfo> getClasses(URL url, String packageDirName, String packageName, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive, Set<ClassInfo> classes) {
        try {
            if (url.toString().startsWith(JAR_FILE) || url.toString().startsWith(WSJAR_FILE)) {
                JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                Enumeration<JarEntry> eje = jarFile.entries();
                while (eje.hasMoreElements()) {
                    JarEntry entry = eje.nextElement();
                    String name = entry.getName();
                    if (name.charAt(0) == '/') {
                        name = name.substring(1);
                    }
                    if (!name.startsWith(packageDirName)) continue;
                    int idx = name.lastIndexOf(47);
                    if (idx != -1) {
                        packageName = name.substring(0, idx).replace('/', '.');
                    }
                    if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                    String className = name.substring(packageName.length() + 1, name.length() - 6);
                    Class<?> clazz = Class.forName(packageName + '.' + className);
                    if (null != parent && null != annotation) {
                        if (null == clazz.getSuperclass() || !clazz.getSuperclass().equals(parent) || null == clazz.getAnnotation(annotation)) continue;
                        classes.add(new ClassInfo(clazz));
                        continue;
                    }
                    if (null != parent) {
                        if (null == clazz.getSuperclass() || !clazz.getSuperclass().equals(parent)) continue;
                        classes.add(new ClassInfo(clazz));
                        continue;
                    }
                    if (null != annotation) {
                        if (null == clazz.getAnnotation(annotation)) continue;
                        classes.add(new ClassInfo(clazz));
                        continue;
                    }
                    classes.add(new ClassInfo(clazz));
                }
            }
        }
        catch (IOException e) {
            log.error("The scan error when the user to define the view from a jar package file.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("", (Throwable)e);
        }
        return classes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JarReaderImpl)) {
            return false;
        }
        JarReaderImpl other = (JarReaderImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof JarReaderImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

