/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.Environment;
import com.blade.ioc.Ioc;
import com.blade.ioc.annotation.Inject;
import com.blade.ioc.annotation.InjectWith;
import com.blade.ioc.annotation.Value;
import com.blade.ioc.bean.BeanDefine;
import com.blade.ioc.bean.ClassDefine;
import com.blade.ioc.bean.FieldInjector;
import com.blade.ioc.bean.ValueInjector;
import com.blade.mvc.http.HttpMethod;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BladeKit {
    private static List<FieldInjector> getInjectFields(Ioc ioc, ClassDefine classDefine) {
        ArrayList<FieldInjector> injectors = new ArrayList<FieldInjector>(8);
        for (Field field : classDefine.getDeclaredFields()) {
            if (null == field.getAnnotation(InjectWith.class) && null == field.getAnnotation(Inject.class)) continue;
            injectors.add(new FieldInjector(ioc, field));
        }
        if (injectors.size() == 0) {
            return new ArrayList<FieldInjector>();
        }
        return injectors;
    }

    private static List<ValueInjector> getValueInjectFields(Environment environment, ClassDefine classDefine) {
        ArrayList<ValueInjector> valueInjectors = new ArrayList<ValueInjector>(8);
        if (null != classDefine.getType().getAnnotation(Value.class)) {
            String suffix = classDefine.getType().getAnnotation(Value.class).name();
            Arrays.stream(classDefine.getDeclaredFields()).forEach(field -> valueInjectors.add(new ValueInjector(environment, (Field)field, suffix + "." + field.getName())));
        } else {
            Arrays.stream(classDefine.getDeclaredFields()).filter(field -> null != field.getAnnotation(Value.class)).map(field -> new ValueInjector(environment, (Field)field, field.getAnnotation(Value.class).name())).forEach(valueInjectors::add);
        }
        return valueInjectors;
    }

    public static void injection(Ioc ioc, BeanDefine beanDefine) {
        ClassDefine classDefine = ClassDefine.create(beanDefine.getType());
        List<FieldInjector> fieldInjectors = BladeKit.getInjectFields(ioc, classDefine);
        Object bean = beanDefine.getBean();
        for (FieldInjector fieldInjector : fieldInjectors) {
            fieldInjector.injection(bean);
        }
    }

    public static void injectionValue(Environment environment, BeanDefine beanDefine) {
        ClassDefine classDefine = ClassDefine.create(beanDefine.getType());
        List<ValueInjector> valueFileds = BladeKit.getValueInjectFields(environment, classDefine);
        Object bean = beanDefine.getBean();
        valueFileds.stream().forEach(fieldInjector -> fieldInjector.injection(bean));
    }

    public static boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    public static <T> boolean isEmpty(T[] arr) {
        return null == arr || arr.length == 0;
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return null != c && !c.isEmpty();
    }

    public static boolean isWebHook(HttpMethod httpMethod) {
        return httpMethod == HttpMethod.BEFORE || httpMethod == HttpMethod.AFTER;
    }

    public static boolean notIsWebHook(HttpMethod httpMethod) {
        return !BladeKit.isWebHook(httpMethod);
    }

    public static boolean epollIsAvailable() {
        try {
            Object obj = Class.forName("io.netty.channel.epoll.Epoll").getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
            return null != obj && Boolean.valueOf(obj.toString()) != false && System.getProperty("os.name").toLowerCase().contains("linux");
        }
        catch (Exception e) {
            return false;
        }
    }
}

