/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.ConvertKit;
import com.blade.kit.IOKit;
import com.blade.kit.StringKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EncryptKit {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String TripleDES_Transformation = "DESede/ECB/NoPadding";
    private static final String TripleDES_Algorithm = "DESede";
    private static String AES_Transformation = "AES/ECB/NoPadding";
    private static final String AES_Algorithm = "AES";
    public static String DES_Transformation = "DES/ECB/NoPadding";
    private static final String DES_Algorithm = "DES";

    public static String md5(String data) {
        return EncryptKit.md5(data.getBytes());
    }

    public static String md5(String data, String salt) {
        return EncryptKit.bytes2HexString(EncryptKit.md5ToByte((data + salt).getBytes()));
    }

    public static String md5(byte[] data) {
        return EncryptKit.bytes2HexString(EncryptKit.md5ToByte(data));
    }

    public static String md5(byte[] data, byte[] salt) {
        if (data == null || salt == null) {
            return null;
        }
        byte[] dataSalt = new byte[data.length + salt.length];
        System.arraycopy(data, 0, dataSalt, 0, data.length);
        System.arraycopy(salt, 0, dataSalt, data.length, salt.length);
        return EncryptKit.bytes2HexString(EncryptKit.md5ToByte(dataSalt));
    }

    static byte[] md5ToByte(byte[] data) {
        return EncryptKit.hashTemplate(data, "MD5");
    }

    public static String md5File(String filePath) {
        File file = StringKit.isBlank(filePath) ? null : new File(filePath);
        return EncryptKit.md5File(file);
    }

    public static byte[] md5FileToByte(String filePath) {
        File file = StringKit.isBlank(filePath) ? null : new File(filePath);
        return EncryptKit.md5FileToByte(file);
    }

    public static String md5File(File file) {
        return EncryptKit.bytes2HexString(EncryptKit.md5FileToByte(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5FileToByte(File file) {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        DigestInputStream digestInputStream = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            md = digestInputStream.getMessageDigest();
            byArray = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            byte[] byArray2;
            try {
                e.printStackTrace();
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOKit.closeQuietly(fis);
                IOKit.closeQuietly(digestInputStream);
                throw throwable;
            }
            IOKit.closeQuietly(fis);
            IOKit.closeQuietly(digestInputStream);
            return byArray2;
        }
        IOKit.closeQuietly(fis);
        IOKit.closeQuietly(digestInputStream);
        return byArray;
    }

    public static String SHA1(String data) {
        return EncryptKit.SHA1(data.getBytes());
    }

    public static String SHA1(byte[] data) {
        return EncryptKit.bytes2HexString(EncryptKit.SHA1ToByte(data));
    }

    public static byte[] SHA1ToByte(byte[] data) {
        return EncryptKit.hashTemplate(data, "SHA1");
    }

    public static String SHA256(String data) {
        return EncryptKit.SHA256(data.getBytes());
    }

    public static String SHA256(byte[] data) {
        return EncryptKit.bytes2HexString(EncryptKit.SHA256ToByte(data));
    }

    public static byte[] SHA256ToByte(byte[] data) {
        return EncryptKit.hashTemplate(data, "SHA-256");
    }

    public static String SHA512(String data) {
        return EncryptKit.SHA512(data.getBytes());
    }

    public static String SHA512(byte[] data) {
        return EncryptKit.bytes2HexString(EncryptKit.SHA512ToByte(data));
    }

    public static byte[] SHA512ToByte(byte[] data) {
        return EncryptKit.hashTemplate(data, "SHA-512");
    }

    private static byte[] hashTemplate(byte[] data, String algorithm) {
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String hmacMd5(String data, String key) {
        return EncryptKit.hmacMd5(data.getBytes(), key.getBytes());
    }

    public static String hmacMd5(byte[] data, byte[] key) {
        return EncryptKit.bytes2HexString(EncryptKit.hmacMd5ToByte(data, key));
    }

    public static byte[] hmacMd5ToByte(byte[] data, byte[] key) {
        return EncryptKit.hmacTemplate(data, key, "HmacMD5");
    }

    public static String hmacSHA1(String data, String key) {
        return EncryptKit.hmacSHA1(data.getBytes(), key.getBytes());
    }

    public static String hmacSHA1(byte[] data, byte[] key) {
        return EncryptKit.bytes2HexString(EncryptKit.hmacSHA1ToByte(data, key));
    }

    public static byte[] hmacSHA1ToByte(byte[] data, byte[] key) {
        return EncryptKit.hmacTemplate(data, key, "HmacSHA1");
    }

    public static String hmacSHA256(String data, String key) {
        return EncryptKit.hmacSHA256(data.getBytes(), key.getBytes());
    }

    public static String hmacSHA256(byte[] data, byte[] key) {
        return EncryptKit.bytes2HexString(EncryptKit.hmacSHA256ToByte(data, key));
    }

    public static byte[] hmacSHA256ToByte(byte[] data, byte[] key) {
        return EncryptKit.hmacTemplate(data, key, "HmacSHA256");
    }

    public static String hmacSHA512(String data, String key) {
        return EncryptKit.hmacSHA512(data.getBytes(), key.getBytes());
    }

    public static String hmacSHA512(byte[] data, byte[] key) {
        return EncryptKit.bytes2HexString(EncryptKit.hmacSHA512ToByte(data, key));
    }

    public static byte[] hmacSHA512ToByte(byte[] data, byte[] key) {
        return EncryptKit.hmacTemplate(data, key, "HmacSHA512");
    }

    private static byte[] hmacTemplate(byte[] data, byte[] key, String algorithm) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(secretKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] DES2Base64(byte[] data, byte[] key) {
        return Base64.getEncoder().encode(EncryptKit.DES(data, key));
    }

    public static String DES2HexString(byte[] data, byte[] key) {
        return EncryptKit.bytes2HexString(EncryptKit.DES(data, key));
    }

    public static byte[] DES(byte[] data, byte[] key) {
        return EncryptKit.desTemplate(data, key, DES_Algorithm, DES_Transformation, true);
    }

    public static byte[] decryptBase64DES(byte[] data, byte[] key) {
        try {
            return EncryptKit.decryptDES(Base64.getDecoder().decode(data), key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] decryptHexStringDES(String data, byte[] key) {
        return EncryptKit.decryptDES(EncryptKit.hexString2Bytes(data), key);
    }

    public static byte[] decryptDES(byte[] data, byte[] key) {
        return EncryptKit.desTemplate(data, key, DES_Algorithm, DES_Transformation, false);
    }

    public static byte[] encrypt3DES2Base64(byte[] data, byte[] key) {
        try {
            return Base64.getEncoder().encode(EncryptKit.encrypt3DES(data, key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encrypt3DES2HexString(byte[] data, byte[] key) {
        return EncryptKit.bytes2HexString(EncryptKit.encrypt3DES(data, key));
    }

    public static byte[] encrypt3DES(byte[] data, byte[] key) {
        return EncryptKit.desTemplate(data, key, TripleDES_Algorithm, TripleDES_Transformation, true);
    }

    public static byte[] decryptBase64_3DES(byte[] data, byte[] key) {
        try {
            return EncryptKit.decrypt3DES(Base64.getDecoder().decode(data), key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] decryptHexString3DES(String data, byte[] key) {
        return EncryptKit.decrypt3DES(EncryptKit.hexString2Bytes(data), key);
    }

    public static byte[] decrypt3DES(byte[] data, byte[] key) {
        return EncryptKit.desTemplate(data, key, TripleDES_Algorithm, TripleDES_Transformation, false);
    }

    public static byte[] encryptAES2Base64(byte[] data, byte[] key) {
        try {
            return Base64.getEncoder().encode(EncryptKit.encryptAES(data, key));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encryptAES2HexString(byte[] data, byte[] key) {
        return EncryptKit.bytes2HexString(EncryptKit.encryptAES(data, key));
    }

    public static byte[] encryptAES(byte[] data, byte[] key) {
        return EncryptKit.desTemplate(data, key, AES_Algorithm, AES_Transformation, true);
    }

    public static byte[] decryptBase64AES(byte[] data, byte[] key) {
        try {
            return EncryptKit.decryptAES(Base64.getDecoder().decode(data), key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] decryptHexStringAES(String data, byte[] key) {
        return EncryptKit.decryptAES(EncryptKit.hexString2Bytes(data), key);
    }

    public static byte[] decryptAES(byte[] data, byte[] key) {
        return EncryptKit.desTemplate(data, key, AES_Algorithm, AES_Transformation, false);
    }

    public static byte[] desTemplate(byte[] data, byte[] key, String algorithm, String transformation, boolean isEncrypt) {
        if (data == null || data.length == 0 || key == null || key.length == 0) {
            return null;
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(transformation);
            SecureRandom random = new SecureRandom();
            cipher.init(isEncrypt ? 1 : 2, (Key)keySpec, random);
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String bytes2HexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        if (len <= 0) {
            return null;
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >>> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(ret).toLowerCase();
    }

    public static byte[] hexString2Bytes(String hexString) {
        if (StringKit.isBlank(hexString)) {
            return null;
        }
        int len = hexString.length();
        if (len % 2 != 0) {
            hexString = "0" + hexString;
            ++len;
        }
        char[] hexBytes = hexString.toUpperCase().toCharArray();
        byte[] ret = new byte[len >> 1];
        for (int i = 0; i < len; i += 2) {
            ret[i >> 1] = (byte)(ConvertKit.hex2Dec(hexBytes[i]) << 4 | ConvertKit.hex2Dec(hexBytes[i + 1]));
        }
        return ret;
    }
}

