/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit.json;

import com.blade.kit.json.Ason;
import com.blade.kit.json.BeanSerializer;
import com.blade.kit.json.JsonSupport;
import com.blade.kit.json.SampleJsonSerializer;
import com.blade.kit.json.SerializeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonSupport
implements JsonSupport {
    private static final Logger log = LoggerFactory.getLogger(DefaultJsonSupport.class);

    @Override
    public String toString(Object object) {
        return this.toString(object, SerializeMapping.defaultMapping());
    }

    @Override
    public <T> T formJson(String json, Class<T> cls) {
        Object jsonObj = SampleJsonSerializer.deserialize(json);
        return BeanSerializer.deserialize(cls, jsonObj);
    }

    public String toString(Object object, SerializeMapping serializeMapping) {
        try {
            Object jsonObj = BeanSerializer.serialize(serializeMapping, object);
            return SampleJsonSerializer.serialize(jsonObj);
        }
        catch (Exception e) {
            log.error("object to json string error", (Throwable)e);
            return null;
        }
    }

    public Ason toAson(String json) {
        Object jsonObj = SampleJsonSerializer.deserialize(json);
        return (Ason)jsonObj;
    }
}

