/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.handler;

import com.blade.exception.BladeException;
import com.blade.exception.InternalErrorException;
import com.blade.exception.NotFoundException;
import com.blade.kit.BladeKit;
import com.blade.kit.ReflectKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.annotation.JSON;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.HttpRequest;
import com.blade.mvc.http.HttpResponse;
import com.blade.mvc.http.Response;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.ModelAndView;
import com.blade.server.netty.HttpServerInitializer;
import com.blade.server.netty.StaticFileHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecution
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RequestExecution.class);
    private final ChannelHandlerContext ctx;
    private final FullHttpRequest fullHttpRequest;
    private final ExceptionHandler exceptionHandler = WebContext.blade().exceptionHandler();
    private static final Set<String> STATICS = WebContext.blade().getStatics();
    private static final RouteMatcher ROUTE_MATCHER = WebContext.blade().routeMatcher();
    private static final boolean hasMiddleware = ROUTE_MATCHER.getMiddleware().size() > 0;
    private static final boolean hasBeforeHook = ROUTE_MATCHER.hasBeforeHook();
    private static final boolean hasAfterHook = ROUTE_MATCHER.hasAfterHook();
    private static final StaticFileHandler STATIC_FILE_HANDLER = new StaticFileHandler(WebContext.blade());

    public RequestExecution(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        this.ctx = ctx;
        this.fullHttpRequest = fullHttpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpRequest request = HttpRequest.build(this.ctx, this.fullHttpRequest);
        HttpResponse response = HttpResponse.build(this.ctx, HttpServerInitializer.date);
        boolean isStatic = false;
        Signature signature = Signature.builder().request(request).response(response).build();
        try {
            String uri = request.uri();
            WebContext.set(new WebContext(request, response));
            if (this.isStaticFile(uri)) {
                STATIC_FILE_HANDLER.handle(this.ctx, request, response);
                isStatic = true;
                return;
            }
            Route route = ROUTE_MATCHER.lookupRoute(request.method(), uri);
            if (null == route) {
                log.warn("Not Found\t{}", (Object)uri);
                throw new NotFoundException(uri);
            }
            log.info("{}\t{}\t{}", new Object[]{request.protocol(), request.method(), uri});
            request.initPathParams(route);
            signature.setRoute(route);
            if (hasMiddleware && !this.invokeMiddleware(ROUTE_MATCHER.getMiddleware(), signature)) {
                this.sendFinish(response);
                return;
            }
            if (hasBeforeHook && !this.invokeHook(ROUTE_MATCHER.getBefore(uri), signature)) {
                this.sendFinish(response);
                return;
            }
            signature.setRoute(route);
            this.routeHandle(signature);
            if (hasAfterHook) {
                this.invokeHook(ROUTE_MATCHER.getAfter(uri), signature);
            }
        }
        catch (Exception e) {
            if (null != this.exceptionHandler) {
                this.exceptionHandler.handle(e);
            } else {
                log.error("Blade Invoke Error", (Throwable)e);
            }
        }
        finally {
            if (!isStatic) {
                this.sendFinish(response);
            }
            WebContext.remove();
        }
    }

    public void routeHandle(Signature signature) throws Exception {
        Object target = signature.getRoute().getTarget();
        if (null == target) {
            Class<?> clazz = signature.getAction().getDeclaringClass();
            target = WebContext.blade().getBean(clazz);
            signature.getRoute().setTarget(target);
        }
        if (signature.getRoute().getTargetType() == RouteHandler.class) {
            RouteHandler routeHandler = (RouteHandler)target;
            routeHandler.handle(signature.request(), signature.response());
        } else {
            this.handle(signature);
        }
    }

    public void handle(Signature signature) throws Exception {
        try {
            int len;
            Object returnParam;
            boolean isRestful;
            Method actionMethod = signature.getAction();
            Object target = signature.getRoute().getTarget();
            Class<?> returnType = actionMethod.getReturnType();
            Response response = signature.response();
            Path path = target.getClass().getAnnotation(Path.class);
            JSON JSON2 = actionMethod.getAnnotation(JSON.class);
            boolean bl = isRestful = null != JSON2 || null != path && path.restful();
            if (isRestful && !signature.request().userAgent().contains("MSIE")) {
                signature.response().contentType("application/json; charset=UTF-8");
            }
            if (null == (returnParam = ReflectKit.invokeMethod(target, actionMethod, (len = actionMethod.getParameterTypes().length) > 0 ? signature.getParameters() : null))) {
                return;
            }
            if (isRestful) {
                response.json(returnParam);
                return;
            }
            if (returnType == String.class) {
                response.render(returnParam.toString());
                return;
            }
            if (returnType == ModelAndView.class) {
                ModelAndView modelAndView = (ModelAndView)returnParam;
                response.render(modelAndView);
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invokeHook(Signature routeSignature, Route hookRoute) throws Exception {
        Object returnParam;
        Method hookMethod = hookRoute.getAction();
        Object target = hookRoute.getTarget();
        if (null == target) {
            Class<?> clazz = hookRoute.getAction().getDeclaringClass();
            target = WebContext.blade().ioc().getBean(clazz);
            hookRoute.setTarget(target);
        }
        int len = hookMethod.getParameterTypes().length;
        hookMethod.setAccessible(true);
        if (len > 0) {
            if (len == 1) {
                returnParam = ReflectKit.invokeMethod(target, hookMethod, routeSignature);
            } else {
                if (len != 2) throw new InternalErrorException("Bad web hook structure");
                returnParam = ReflectKit.invokeMethod(target, hookMethod, routeSignature.request(), routeSignature.response());
            }
        } else {
            returnParam = ReflectKit.invokeMethod(target, hookMethod, new Object[0]);
        }
        if (null == returnParam) {
            return true;
        }
        Class<?> returnType = returnParam.getClass();
        if (returnType != Boolean.class && returnType != Boolean.TYPE) return true;
        return Boolean.valueOf(returnParam.toString());
    }

    public boolean invokeMiddleware(List<Route> middleware, Signature signature) throws BladeException {
        if (BladeKit.isEmpty(middleware)) {
            return true;
        }
        for (Route route : middleware) {
            WebHook webHook = (WebHook)route.getTarget();
            boolean flag = webHook.before(signature);
            if (flag) continue;
            return false;
        }
        return true;
    }

    public boolean invokeHook(List<Route> hooks, Signature signature) throws Exception {
        for (Route hook : hooks) {
            if (hook.getTargetType() == RouteHandler.class) {
                RouteHandler routeHandler = (RouteHandler)hook.getTarget();
                routeHandler.handle(signature.request(), signature.response());
                continue;
            }
            boolean flag = this.invokeHook(signature, hook);
            if (flag) continue;
            return false;
        }
        return true;
    }

    private boolean isStaticFile(String uri) {
        Optional<String> result = STATICS.stream().filter(s -> s.equals(uri) || uri.startsWith((String)s)).findFirst();
        return result.isPresent();
    }

    private void sendFinish(Response response) {
        if (!response.isCommit()) {
            response.body(Unpooled.EMPTY_BUFFER);
        }
    }
}

