/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Session;
import com.blade.mvc.multipart.FileItem;
import com.blade.mvc.route.Route;
import com.blade.server.netty.SessionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest
implements Request {
    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    private static final HttpDataFactory HTTP_DATA_FACTORY = new DefaultHttpDataFactory(16384L);
    private static final SessionHandler SESSION_HANDLER = WebContext.sessionManager() != null ? new SessionHandler(WebContext.blade()) : null;
    private ByteBuf body = Unpooled.copiedBuffer((CharSequence)"", (Charset)CharsetUtil.UTF_8);
    private String remoteAddress;
    private String uri;
    private String url;
    private String protocol;
    private String method;
    private boolean keepAlive;
    private Map<String, String> headers = null;
    private Map<String, Object> attributes = null;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private Map<String, String> pathParams = null;
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private Map<String, FileItem> fileItems = new HashMap<String, FileItem>();

    private void init(FullHttpRequest fullHttpRequest) {
        String cookie;
        HttpHeaders httpHeaders = fullHttpRequest.headers();
        if (httpHeaders.size() > 0) {
            this.headers = new HashMap<String, String>(httpHeaders.size());
            httpHeaders.forEach(header -> this.headers.put((String)header.getKey(), (String)header.getValue()));
        } else {
            this.headers = new HashMap<String, String>();
        }
        this.body = fullHttpRequest.content().copy();
        Map parameters = new QueryStringDecoder(fullHttpRequest.uri(), CharsetUtil.UTF_8).parameters();
        if (null != parameters) {
            this.parameters = new HashMap<String, List<String>>();
            this.parameters.putAll(parameters);
        }
        if (!"GET".equals(fullHttpRequest.method().name())) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(HTTP_DATA_FACTORY, (io.netty.handler.codec.http.HttpRequest)fullHttpRequest);
            decoder.getBodyHttpDatas().forEach(this::parseData);
        }
        String string = cookie = (cookie = this.header("Cookie")).length() > 0 ? cookie : this.header("Cookie".toLowerCase());
        if (StringKit.isNotBlank(cookie)) {
            ServerCookieDecoder.LAX.decode(cookie).forEach(this::parseCookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseData(InterfaceHttpData data) {
        try {
            switch (data.getHttpDataType()) {
                case Attribute: {
                    Attribute attribute = (Attribute)data;
                    String name = attribute.getName();
                    String value = attribute.getValue();
                    this.parameters.put(name, Collections.singletonList(value));
                    return;
                }
                case FileUpload: {
                    FileUpload fileUpload = (FileUpload)data;
                    this.parseFileUpload(fileUpload);
                    return;
                }
            }
            return;
        }
        catch (IOException e) {
            log.error("parse request parameter error", (Throwable)e);
            return;
        }
        finally {
            data.release();
        }
    }

    private void parseFileUpload(FileUpload fileUpload) throws IOException {
        if (fileUpload.isCompleted()) {
            String contentType = StringKit.mimeType(fileUpload.getFilename());
            if (null == contentType) {
                contentType = URLConnection.guessContentTypeFromName(fileUpload.getFilename());
            }
            if (fileUpload.isInMemory()) {
                FileItem fileItem = new FileItem(fileUpload.getName(), fileUpload.getFilename(), contentType, fileUpload.length());
                ByteBuf byteBuf = fileUpload.getByteBuf();
                fileItem.setData(ByteBufUtil.getBytes((ByteBuf)byteBuf));
                this.fileItems.put(fileItem.getName(), fileItem);
            } else {
                FileItem fileItem = new FileItem(fileUpload.getName(), fileUpload.getFilename(), contentType, fileUpload.length());
                byte[] bytes = Files.readAllBytes(fileUpload.getFile().toPath());
                fileItem.setData(bytes);
                this.fileItems.put(fileItem.getName(), fileItem);
            }
        }
    }

    private void parseCookie(io.netty.handler.codec.http.cookie.Cookie nettyCookie) {
        Cookie cookie = new Cookie();
        cookie.name(nettyCookie.name());
        cookie.value(nettyCookie.value());
        cookie.httpOnly(nettyCookie.isHttpOnly());
        cookie.path(nettyCookie.path());
        cookie.domain(nettyCookie.domain());
        cookie.maxAge(nettyCookie.maxAge());
        this.cookies.put(cookie.name(), cookie);
    }

    @Override
    public Request initPathParams(@NonNull Route route) {
        if (route == null) {
            throw new NullPointerException("route");
        }
        if (null != route.getPathParams()) {
            this.pathParams = route.getPathParams();
        }
        return this;
    }

    @Override
    public String host() {
        return this.header("Host");
    }

    @Override
    public String remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    @Override
    public String queryString() {
        if (null != this.url && this.url.contains("?")) {
            return this.url.substring(this.url.indexOf("?") + 1);
        }
        return "";
    }

    @Override
    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public HttpMethod httpMethod() {
        return HttpMethod.valueOf(this.method());
    }

    @Override
    public Session session() {
        return SESSION_HANDLER.createSession(this);
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isIE() {
        String ua = this.userAgent();
        return ua.contains("MSIE") || ua.contains("TRIDENT");
    }

    @Override
    public Map<String, Cookie> cookies() {
        return this.cookies;
    }

    @Override
    public Cookie cookieRaw(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.cookies.get(name);
    }

    @Override
    public Request cookie(@NonNull Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        this.cookies.put(cookie.name(), cookie);
        return this;
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public boolean keepAlive() {
        return this.keepAlive;
    }

    @Override
    public Map<String, Object> attributes() {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, Object>(4);
        }
        return this.attributes;
    }

    @Override
    public Map<String, FileItem> fileItems() {
        return this.fileItems;
    }

    @Override
    public ByteBuf body() {
        return this.body;
    }

    @Override
    public String bodyToString() {
        return this.body.toString(CharsetUtil.UTF_8);
    }

    public HttpRequest() {
    }

    public HttpRequest(Request request) {
        this.pathParams = request.pathParams();
        this.cookies = request.cookies();
        this.attributes = request.attributes();
        this.body = request.body();
        this.fileItems = request.fileItems();
        this.headers = request.headers();
        this.keepAlive = request.keepAlive();
        this.method = request.method();
        this.url = request.url();
        if (null != this.url && this.url.length() > 0) {
            int pathEndPos = this.url.indexOf(63);
            this.uri = pathEndPos < 0 ? this.url : this.url.substring(0, pathEndPos);
        }
        this.parameters = request.parameters();
        this.protocol = request.protocol();
    }

    public static HttpRequest build(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        String remoteAddress;
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.keepAlive = HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest);
        httpRequest.remoteAddress = remoteAddress = ctx.channel().remoteAddress().toString();
        httpRequest.url = fullHttpRequest.uri();
        int pathEndPos = httpRequest.url.indexOf(63);
        httpRequest.uri = pathEndPos < 0 ? httpRequest.url : httpRequest.url.substring(0, pathEndPos);
        httpRequest.protocol = fullHttpRequest.protocolVersion().text();
        httpRequest.method = fullHttpRequest.method().name();
        httpRequest.init(fullHttpRequest);
        return httpRequest;
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
    }
}

