/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.exception.NotFoundException;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.Response;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.wrapper.OutputStreamWrapper;
import com.blade.server.netty.HttpConst;
import com.blade.server.netty.ProgressiveFutureListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponse
implements Response {
    private static final Logger log = LoggerFactory.getLogger(HttpResponse.class);
    private HttpHeaders headers = new DefaultHttpHeaders(false);
    private Set<io.netty.handler.codec.http.cookie.Cookie> cookies = new HashSet<io.netty.handler.codec.http.cookie.Cookie>(4);
    private int statusCode = 200;
    private boolean isCommit = false;
    private ChannelHandlerContext ctx = null;
    private CharSequence contentType = null;
    private CharSequence dateString = null;

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public Response status(int status) {
        this.statusCode = status;
        return this;
    }

    @Override
    public Response contentType(@NonNull CharSequence contentType) {
        if (contentType == null) {
            throw new NullPointerException("contentType");
        }
        this.contentType = contentType;
        return this;
    }

    @Override
    public String contentType() {
        return null == this.contentType ? null : String.valueOf(this.contentType);
    }

    @Override
    public Map<String, String> headers() {
        HashMap<String, String> map = new HashMap<String, String>(this.headers.size());
        this.headers.forEach(header -> {
            String cfr_ignored_0 = (String)map.put((String)header.getKey(), (String)header.getValue());
        });
        return map;
    }

    @Override
    public Response header(CharSequence name, CharSequence value) {
        this.headers.set(name, (Object)value);
        return this;
    }

    @Override
    public Response cookie(@NonNull Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        DefaultCookie nettyCookie = new DefaultCookie(cookie.name(), cookie.value());
        if (cookie.domain() != null) {
            nettyCookie.setDomain(cookie.domain());
        }
        if (cookie.maxAge() > 0L) {
            nettyCookie.setMaxAge(cookie.maxAge());
        }
        nettyCookie.setPath(cookie.path());
        nettyCookie.setHttpOnly(cookie.httpOnly());
        nettyCookie.setSecure(cookie.secure());
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(String name, String value) {
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)new DefaultCookie(name, value));
        return this;
    }

    @Override
    public Response cookie(@NonNull String name, @NonNull String value, int maxAge) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setPath("/");
        nettyCookie.setMaxAge((long)maxAge);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(@NonNull String name, @NonNull String value, int maxAge, boolean secured) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setPath("/");
        nettyCookie.setMaxAge((long)maxAge);
        nettyCookie.setSecure(secured);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(@NonNull String path, @NonNull String name, @NonNull String value, int maxAge, boolean secured) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setMaxAge((long)maxAge);
        nettyCookie.setSecure(secured);
        nettyCookie.setPath(path);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response removeCookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<io.netty.handler.codec.http.cookie.Cookie> cookieOpt = this.cookies.stream().filter(cookie -> cookie.name().equals(name)).findFirst();
        cookieOpt.ifPresent(cookie -> {
            cookie.setValue("");
            cookie.setMaxAge(-1L);
        });
        DefaultCookie nettyCookie = new DefaultCookie(name, "");
        nettyCookie.setMaxAge(-1L);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Map<String, String> cookies() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        this.cookies.forEach(cookie -> map.put(cookie.name(), cookie.value()));
        return map;
    }

    @Override
    public void download(@NonNull String fileName, @NonNull File file) throws Exception {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.exists() || !file.isFile()) {
            throw new NotFoundException("Not found file: " + file.getPath());
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        Long fileLength = raf.length();
        this.contentType = StringKit.mimeType(file.getName());
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders httpHeaders = httpResponse.headers().add(this.getDefaultHeader());
        boolean keepAlive = WebContext.request().keepAlive();
        if (keepAlive) {
            httpResponse.headers().set(HttpConst.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        httpHeaders.set(HttpConst.CONTENT_TYPE, (Object)this.contentType);
        httpHeaders.set("Content-Disposition", (Object)("attachment; filename=" + new String(fileName.getBytes("UTF-8"), "ISO8859_1")));
        httpHeaders.setInt(HttpConst.CONTENT_LENGTH, fileLength.intValue());
        this.ctx.write((Object)httpResponse);
        ChannelFuture sendFileFuture = this.ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength.longValue()), (ChannelPromise)this.ctx.newProgressivePromise());
        ChannelFuture lastContentFuture = this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        sendFileFuture.addListener((GenericFutureListener)ProgressiveFutureListener.build(raf));
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.isCommit = true;
    }

    @Override
    public OutputStreamWrapper outputStream() throws IOException {
        File file = Files.createTempFile("blade", ".temp", new FileAttribute[0]).toFile();
        FileOutputStream outputStream = new FileOutputStream(file);
        return new OutputStreamWrapper(outputStream, file, this.ctx);
    }

    @Override
    public void render(@NonNull ModelAndView modelAndView) {
        if (modelAndView == null) {
            throw new NullPointerException("modelAndView");
        }
        StringWriter sw = new StringWriter();
        try {
            WebContext.blade().templateEngine().render(modelAndView, sw);
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])sw.toString().getBytes("utf-8"));
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode), buffer);
            this.send((FullHttpResponse)response);
        }
        catch (Exception e) {
            log.error("render error", (Throwable)e);
        }
    }

    @Override
    public void redirect(@NonNull String newUri) {
        if (newUri == null) {
            throw new NullPointerException("newUri");
        }
        this.headers.set(HttpConst.LOCATION, (Object)newUri);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        this.send((FullHttpResponse)response);
    }

    @Override
    public boolean isCommit() {
        return this.isCommit;
    }

    @Override
    public void send(@NonNull FullHttpResponse response) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        response.headers().set(this.getDefaultHeader());
        boolean keepAlive = WebContext.request().keepAlive();
        if (!response.headers().contains(HttpConst.CONTENT_LENGTH)) {
            response.headers().set(HttpConst.CONTENT_LENGTH, (Object)String.valueOf(response.content().readableBytes()));
        }
        if (!keepAlive) {
            this.ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set(HttpConst.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            this.ctx.write((Object)response, this.ctx.voidPromise());
        }
        this.isCommit = true;
    }

    private HttpHeaders getDefaultHeader() {
        this.headers.set(HttpConst.DATE, (Object)this.dateString);
        this.headers.set(HttpConst.CONTENT_TYPE, (Object)HttpConst.getContentType(this.contentType));
        this.headers.set(HttpConst.X_POWER_BY, (Object)HttpConst.VERSION);
        if (!this.headers.contains(HttpConst.SERVER)) {
            this.headers.set(HttpConst.SERVER, (Object)HttpConst.VERSION);
        }
        if (this.cookies.size() > 0) {
            this.cookies.forEach(cookie -> this.headers.add(HttpConst.SET_COOKIE, (Object)ServerCookieEncoder.LAX.encode(cookie)));
        }
        return this.headers;
    }

    public HttpResponse(Response response) {
        this.contentType = response.contentType();
        this.statusCode = response.statusCode();
        if (null != response.headers()) {
            response.headers().forEach((arg_0, arg_1) -> ((HttpHeaders)this.headers).add(arg_0, arg_1));
        }
        if (null != response.cookies()) {
            response.cookies().forEach((k, v) -> this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)new DefaultCookie(k, v)));
        }
    }

    public HttpResponse() {
    }

    public static HttpResponse build(ChannelHandlerContext ctx, CharSequence dateString) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.ctx = ctx;
        httpResponse.dateString = dateString;
        return httpResponse;
    }
}

