/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.auth;

import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthMiddleware
implements WebHook {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthMiddleware.class);
    private static final int AUTH_LENGTH = 6;
    private static final int AUTH_FIELD_LENGTH = 2;
    private String username;
    private String password;

    @Override
    public boolean before(Signature signature) {
        Request request;
        Object basicAuth;
        if (null == this.username) {
            this.username = WebContext.blade().environment().get("http.auth.username", "blade");
            this.password = WebContext.blade().environment().get("http.auth.password", "blade");
        }
        if (null != (basicAuth = (request = signature.request()).session().attribute("basic_auth"))) {
            return true;
        }
        Response response = signature.response();
        if (!this.checkHeaderAuth(request)) {
            response.unauthorized();
            response.header("Cache-Control", "no-store");
            response.header("Expires", "0");
            response.header("WWW-authenticate", "Basic Realm=\"Blade\"");
            return false;
        }
        return true;
    }

    private boolean checkHeaderAuth(Request request) {
        String auth = request.header("Authorization");
        log.debug("Authorization: {}", (Object)auth);
        if (StringKit.isNotBlank(auth) && auth.length() > 6) {
            auth = auth.substring(6, auth.length());
            String decodedAuth = this.getFromBASE64(auth);
            log.debug("Authorization decode: {}", (Object)decodedAuth);
            if (null == decodedAuth || !decodedAuth.contains(":")) {
                return false;
            }
            String[] arr = decodedAuth.split(":");
            if (arr.length == 2 && this.username.equals(arr[0]) && this.password.equals(arr[1])) {
                request.session().attribute("basic_auth", decodedAuth);
                return true;
            }
        }
        return false;
    }

    private String getFromBASE64(String s) {
        if (s == null) {
            return null;
        }
        try {
            byte[] b = Base64.getDecoder().decode(s);
            return new String(b);
        }
        catch (Exception e) {
            return null;
        }
    }
}

