/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.csrf;

import com.blade.kit.StringKit;
import com.blade.kit.UUID;
import com.blade.mvc.WebContext;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.security.web.csrf.CsrfConfig;
import com.blade.security.web.csrf.CsrfToken;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfMiddleware
implements WebHook {
    private static final Logger log = LoggerFactory.getLogger(CsrfMiddleware.class);
    private Set<String> tokens = new HashSet<String>(64);
    private CsrfConfig csrfConfig = CsrfConfig.builder().build();
    private Consumer<Response> csrfHandle = response -> response.badRequest().text("Bad Request.");

    public CsrfMiddleware() {
    }

    public CsrfMiddleware(Consumer<Response> csrfHandle) {
        this.csrfHandle = csrfHandle;
    }

    public CsrfMiddleware(CsrfConfig csrfConfig, Consumer<Response> csrfHandle) {
        this.csrfConfig = csrfConfig;
        this.csrfHandle = csrfHandle;
    }

    @Override
    public boolean before(Signature signature) {
        Request request = signature.request();
        Method method = signature.getAction();
        CsrfToken csrfToken = method.getAnnotation(CsrfToken.class);
        if (null == csrfToken) {
            return true;
        }
        if (csrfToken.newToken()) {
            request.attribute(this.csrfConfig.getParam(), this.csrfConfig.getKey());
            request.attribute(this.csrfConfig.getHeader(), this.csrfConfig.getKey());
            String token = UUID.UU64();
            request.attribute(this.csrfConfig.getKey(), token);
            log.debug("Generate token [{}]", (Object)token);
            this.tokens.add(token);
        }
        if (csrfToken.valid() || StringKit.equals(Boolean.TRUE.toString(), signature.getRequest().header(this.csrfConfig.getValidId()))) {
            return this.validation();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean validation() {
        Request request = WebContext.request();
        Response response = WebContext.response();
        Optional<String> tokenOptional = request.query(this.csrfConfig.getKey());
        if (!tokenOptional.isPresent()) {
            tokenOptional = Optional.ofNullable(request.header(this.csrfConfig.getKey()));
        }
        if (!tokenOptional.isPresent()) {
            this.csrfHandle.accept(response);
            return false;
        }
        if (!this.tokens.contains(tokenOptional.get())) {
            this.csrfHandle.accept(response);
            return false;
        }
        this.tokens.remove(tokenOptional.get());
        return true;
    }
}

