/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import io.netty.util.AsciiString;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface HttpConst {
    public static final String IF_MODIFIED_SINCE = "IF_MODIFIED_SINCE";
    public static final String USER_AGENT = "User-Agent";
    public static final String CONTENT_TYPE_STRING = "Content-Type";
    public static final String COOKIE_STRING = "Cookie";
    public static final String METHOD_GET = "GET";
    public static final String IE_UA = "MSIE";
    public static final String DEFAULT_SESSION_KEY = "SESSION";
    public static final String SLASH = "/";
    public static final char CHAR_SLASH = '/';
    public static final char CHAR_POINT = '.';
    public static final CharSequence CONNECTION = AsciiString.cached((String)"Connection");
    public static final CharSequence CONTENT_LENGTH = AsciiString.cached((String)"Content-Length");
    public static final CharSequence CONTENT_TYPE = AsciiString.cached((String)"Content-Type");
    public static final CharSequence DATE = AsciiString.cached((String)"Date");
    public static final CharSequence LOCATION = AsciiString.cached((String)"Location");
    public static final CharSequence X_POWER_BY = AsciiString.cached((String)"X-Powered-By");
    public static final CharSequence EXPIRES = AsciiString.cached((String)"Expires");
    public static final CharSequence CACHE_CONTROL = AsciiString.cached((String)"Cache-Control");
    public static final CharSequence LAST_MODIFIED = AsciiString.cached((String)"Last-Modified");
    public static final CharSequence SERVER = AsciiString.cached((String)"Server");
    public static final CharSequence SET_COOKIE = AsciiString.cached((String)"Set-Cookie");
    public static final CharSequence KEEP_ALIVE = AsciiString.cached((String)"Keep-Alive");
    public static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    public static final CharSequence VERSION = AsciiString.cached((String)"blade-2.0.6-BETA");
    public static final Map<CharSequence, CharSequence> contentTypes = new ConcurrentHashMap<CharSequence, CharSequence>(8);

    public static CharSequence getContentType(CharSequence contentType) {
        if (null == contentType) {
            contentType = CONTENT_TYPE_HTML;
        }
        if (contentTypes.containsKey(contentType)) {
            return contentTypes.get(contentType);
        }
        contentTypes.put(contentType, (CharSequence)AsciiString.cached((String)String.valueOf(contentType)));
        return contentTypes.get(contentType);
    }
}

