/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.mvc.WebContext;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.RequestExecution;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    private final ExceptionHandler exceptionHandler = WebContext.blade().exceptionHandler();

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        new RequestExecution(ctx, fullHttpRequest.copy()).run();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (ctx.channel().isOpen() && ctx.channel().isActive() && ctx.channel().isWritable()) {
            ctx.flush();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (null != this.exceptionHandler) {
            this.exceptionHandler.handle((Exception)cause);
        } else {
            log.error("Blade Invoke Error", cause);
        }
        if (ctx.channel().isOpen() && ctx.channel().isActive() && ctx.channel().isWritable()) {
            ctx.close();
        }
    }
}

