/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.kit.DateKit;
import com.blade.server.netty.HttpServerHandler;
import com.blade.server.netty.WebSockerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private final Blade blade;
    private final boolean enableGzip;
    private final boolean enableCors;
    private final ScheduledExecutorService service;
    public static volatile CharSequence date = new AsciiString((CharSequence)DateKit.gmtDate(LocalDateTime.now()));

    public HttpServerInitializer(SslContext sslCtx, Blade blade, ScheduledExecutorService service) {
        this.sslCtx = sslCtx;
        this.blade = blade;
        this.service = service;
        this.enableGzip = blade.environment().getBoolean("http.gzip.enable", false);
        this.enableCors = blade.environment().getBoolean("http.cors.enable", false);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        if (this.enableGzip) {
            p.addLast(new ChannelHandler[]{new HttpContentCompressor()});
        }
        p.addLast(new ChannelHandler[]{new HttpServerCodec(72384, 289536, 579072, false)});
        p.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        if (this.enableCors) {
            CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowNullOrigin().allowCredentials().build();
            p.addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
        }
        if (null != this.blade.webSocketPath()) {
            p.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(this.blade.webSocketPath(), null, true)});
            p.addLast(new ChannelHandler[]{new WebSockerHandler(this.blade)});
        }
        this.service.scheduleWithFixedDelay(() -> {
            date = new AsciiString((CharSequence)DateKit.gmtDate(LocalDateTime.now()));
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        p.addLast(new ChannelHandler[]{new HttpServerHandler()});
    }
}

