/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.Environment;
import com.blade.event.BeanProcessor;
import com.blade.event.EventType;
import com.blade.ioc.DynamicContext;
import com.blade.ioc.Ioc;
import com.blade.ioc.annotation.Bean;
import com.blade.ioc.annotation.Value;
import com.blade.ioc.bean.BeanDefine;
import com.blade.ioc.bean.ClassInfo;
import com.blade.ioc.bean.OrderComparator;
import com.blade.kit.BladeKit;
import com.blade.kit.NamedThreadFactory;
import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.mvc.Const;
import com.blade.mvc.WebContext;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.annotation.UrlPattern;
import com.blade.mvc.handler.DefaultExceptionHandler;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.route.RouteBuilder;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.template.DefaultEngine;
import com.blade.server.Server;
import com.blade.server.netty.EpollKit;
import com.blade.server.netty.HttpServerInitializer;
import com.blade.server.netty.NettyServerGroup;
import com.blade.watcher.EnvironmentWatcher;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private Blade blade;
    private Environment environment;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private RouteBuilder routeBuilder;
    private List<BeanProcessor> processors;

    @Override
    public void start(Blade blade, String[] args) throws Exception {
        this.blade = blade;
        this.environment = blade.environment();
        this.processors = blade.processors();
        long initStart = System.currentTimeMillis();
        log.info("Environment: jdk.version    => {}", (Object)System.getProperty("java.version"));
        log.info("Environment: user.dir       => {}", (Object)System.getProperty("user.dir"));
        log.info("Environment: java.io.tmpdir => {}", (Object)System.getProperty("java.io.tmpdir"));
        log.info("Environment: user.timezone  => {}", (Object)System.getProperty("user.timezone"));
        log.info("Environment: file.encoding  => {}", (Object)System.getProperty("file.encoding"));
        log.info("Environment: classpath      => {}", (Object)Const.CLASSPATH);
        this.loadConfig(args);
        this.initConfig();
        WebContext.init(blade, "/");
        this.initIoc();
        this.shutdownHook();
        this.watchEnv();
        this.startServer(initStart);
    }

    private void initIoc() {
        List<BeanDefine> beanDefines;
        RouteMatcher routeMatcher = this.blade.routeMatcher();
        routeMatcher.initMiddleware(this.blade.middleware());
        this.routeBuilder = new RouteBuilder(routeMatcher);
        this.blade.scanPackages().stream().flatMap(DynamicContext::recursionFindClasses).map(ClassInfo::getClazz).filter(ReflectKit::isNormalClass).forEach(this::parseCls);
        this.routeBuilder.register();
        this.processors.stream().sorted(new OrderComparator()).forEach(b -> b.preHandle(this.blade));
        Ioc ioc = this.blade.ioc();
        if (BladeKit.isNotEmpty(ioc.getBeans())) {
            log.info("\u2b22 Register bean: {}", ioc.getBeans());
        }
        if (BladeKit.isNotEmpty(beanDefines = ioc.getBeanDefines())) {
            beanDefines.forEach(b -> {
                BladeKit.injection(ioc, b);
                BladeKit.injectionValue(this.environment, b);
            });
        }
        this.processors.stream().sorted(new OrderComparator()).forEach(b -> b.processor(this.blade));
    }

    private void startServer(long startTime) throws Exception {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        boolean SSL = this.environment.getBoolean("server.ssl.enable", false);
        SslContext sslCtx = null;
        if (SSL) {
            String certFilePath = this.environment.get("server.ssl.cert-path", null);
            String privateKeyPath = this.environment.get("server.ssl.private-key-path", null);
            String privateKeyPassword = this.environment.get("server.ssl.private-key-pass", null);
            log.info("\u2b22 SSL CertChainFile  Path: {}", (Object)certFilePath);
            log.info("\u2b22 SSL PrivateKeyFile Path: {}", (Object)privateKeyPath);
            sslCtx = SslContextBuilder.forServer((File)new File(certFilePath), (File)new File(privateKeyPath), (String)privateKeyPassword).build();
        }
        int backlog = this.environment.getInt("server.netty.so-backlog", 8192);
        ServerBootstrap b = new ServerBootstrap();
        b.option(ChannelOption.SO_BACKLOG, (Object)backlog);
        b.option(ChannelOption.SO_REUSEADDR, (Object)true);
        b.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        int acceptThreadCount = this.environment.getInt("server.netty.accept-thread-count", 0);
        int ioThreadCount = this.environment.getInt("server.netty.io-thread-count", 0);
        if (BladeKit.epollIsAvailable()) {
            log.info("\u2b22 Use EpollEventLoopGroup");
            b.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            NettyServerGroup nettyServerGroup = EpollKit.group(acceptThreadCount, ioThreadCount);
            this.bossGroup = nettyServerGroup.getBoosGroup();
            this.workerGroup = nettyServerGroup.getWorkerGroup();
            b.group(this.bossGroup, this.workerGroup).channel(nettyServerGroup.getSocketChannel());
        } else {
            log.info("\u2b22 Use NioEventLoopGroup");
            this.bossGroup = new NioEventLoopGroup(acceptThreadCount, (ThreadFactory)new NamedThreadFactory("nio-boss@"));
            this.workerGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedThreadFactory("nio-worker@"));
            b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
        }
        ((ServerBootstrap)b.handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new HttpServerInitializer(sslCtx, this.blade, (ScheduledExecutorService)this.bossGroup.next()));
        String address = this.environment.get("server.address", "0.0.0.0");
        int port = this.environment.getInt("server.port", 9000);
        this.channel = b.bind(address, port).sync().channel();
        String appName = this.environment.get("app.name", "Blade");
        log.info("\u2b22 {} initialize successfully, Time elapsed: {} ms", (Object)appName, (Object)(System.currentTimeMillis() - startTime));
        log.info("\u2b22 Blade start with {}:{}", (Object)address, (Object)port);
        log.info("\u2b22 Open your web browser and navigate to {}://{}:{} \u26a1", new Object[]{"http", address.replace("0.0.0.0", "127.0.0.1"), port});
        this.blade.eventManager().fireEvent(EventType.SERVER_STARTED, this.blade);
    }

    private void parseCls(Class<?> clazz) {
        if (null != clazz.getAnnotation(Bean.class) || null != clazz.getAnnotation(Value.class)) {
            this.blade.register(clazz);
        }
        if (null != clazz.getAnnotation(Path.class)) {
            if (null == this.blade.ioc().getBean(clazz)) {
                this.blade.register(clazz);
            }
            Object controller = this.blade.ioc().getBean(clazz);
            this.routeBuilder.addRouter(clazz, controller);
        }
        if (ReflectKit.hasInterface(clazz, WebHook.class) && null != clazz.getAnnotation(Bean.class)) {
            Object hook = this.blade.ioc().getBean(clazz);
            UrlPattern urlPattern = clazz.getAnnotation(UrlPattern.class);
            if (null == urlPattern) {
                this.routeBuilder.addWebHook(clazz, "/.*", hook);
            } else {
                Stream.of(urlPattern.values()).forEach(pattern -> this.routeBuilder.addWebHook(clazz, (String)pattern, hook));
            }
        }
        if (ReflectKit.hasInterface(clazz, BeanProcessor.class) && null != clazz.getAnnotation(Bean.class)) {
            this.processors.add((BeanProcessor)this.blade.ioc().getBean(clazz));
        }
        if (this.isExceptionHandler(clazz)) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)this.blade.ioc().getBean(clazz);
            this.blade.exceptionHandler(exceptionHandler);
        }
    }

    private boolean isExceptionHandler(Class<?> clazz) {
        return null != clazz.getAnnotation(Bean.class) && (ReflectKit.hasInterface(clazz, ExceptionHandler.class) || clazz.getSuperclass().equals(DefaultExceptionHandler.class));
    }

    private void watchEnv() {
        boolean watchEnv = this.environment.getBoolean("app.watch-env", true);
        log.info("\u2b22 Watched environment: {}", (Object)watchEnv);
        if (watchEnv) {
            Thread t = new Thread(new EnvironmentWatcher());
            t.setName("watch@thread");
            t.start();
        }
    }

    private void loadConfig(String[] args) {
        String bootConf = this.blade.environment().get("boot_conf", "classpath:app.properties");
        Environment bootEnv = Environment.of(bootConf);
        if (bootEnv != null) {
            bootEnv.props().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.environment.set(key.toString(), value)));
        }
        if (null != args) {
            Optional<String> envArg = Stream.of(args).filter(s -> s.startsWith("--blade.env=")).findFirst();
            envArg.ifPresent(arg -> {
                String envName = "app-" + arg.split("=")[1] + ".properties";
                log.info("current environment file is: {}", (Object)envName);
                Environment customEnv = Environment.of(envName);
                if (customEnv != null) {
                    customEnv.props().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.environment.set(key.toString(), value)));
                }
            });
        }
        this.blade.register(this.environment);
        if (!BladeKit.isEmpty(args)) {
            for (String arg2 : args) {
                int pos;
                if (arg2.startsWith("--server.address=")) {
                    pos = arg2.indexOf("--server.address=") + "--server.address=".length();
                    String address = arg2.substring(pos);
                    this.environment.set("server.address", address);
                    continue;
                }
                if (!arg2.startsWith("--server.port=")) continue;
                pos = arg2.indexOf("--server.port=") + "--server.port=".length();
                String port = arg2.substring(pos);
                this.environment.set("server.port", port);
            }
        }
    }

    private void initConfig() {
        String templatePath;
        if (null != this.blade.bootClass()) {
            this.blade.scanPackages(this.blade.bootClass().getPackage().getName());
        }
        this.printBanner();
        String statics = this.environment.get("mvc.statics", "");
        if (StringKit.isNotBlank(statics)) {
            this.blade.addStatics(statics.split(","));
        }
        if ((templatePath = this.environment.get("mvc.template.path", "templates")).charAt(0) == '/') {
            templatePath = templatePath.substring(1);
        }
        if (templatePath.endsWith("/")) {
            templatePath = templatePath.substring(0, templatePath.length() - 1);
        }
        DefaultEngine.TEMPLATE_PATH = templatePath;
    }

    private void shutdownHook() {
        Thread shutdownThread = new Thread(this::stop);
        shutdownThread.setName("shutdown@thread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    @Override
    public void stop() {
        log.info("\u2b22 Blade shutdown ...");
        try {
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
            }
            log.info("\u2b22 Blade shutdown successful");
        }
        catch (Exception e) {
            log.error("Blade shutdown error", (Throwable)e);
        }
    }

    @Override
    public void stopAndWait() {
        log.info("\u2b22 Blade shutdown ...");
        try {
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully().sync();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully().sync();
            }
            log.info("\u2b22 Blade shutdown successful");
        }
        catch (Exception e) {
            log.error("Blade shutdown error", (Throwable)e);
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.channel.closeFuture().sync();
    }

    private void printBanner() {
        if (null != this.blade.bannerText()) {
            System.out.println(this.blade.bannerText());
        } else {
            StringBuilder text = new StringBuilder();
            text.append("\r\n\t\t\t\t\t\t\t      __, _,   _, __, __,\r\n\t\t\t\t\t\t\t      |_) |   /_\\ | \\ |_\r\n\t\t\t\t\t\t\t      |_) | , | | |_/ |\r\n\t\t\t\t\t\t\t      ~   ~~~ ~ ~ ~   ~~~");
            text.append("\r\n").append("\t\t\t\t\t\t\t  ").append(" :: Blade :: (v").append("2.0.6-BETA) \r\n");
            System.out.println(text.toString());
        }
    }
}

