/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.event.EventManager;
import com.blade.event.EventType;
import com.blade.kit.ReflectKit;
import com.blade.kit.UUID;
import com.blade.mvc.SessionManager;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.Session;
import java.time.Instant;

public class SessionHandler {
    private final Blade blade;
    private final SessionManager sessionManager;
    private final EventManager eventManager;
    private final String sessionKey;
    private final int timeout;

    public SessionHandler(Blade blade) {
        this.blade = blade;
        this.sessionManager = blade.sessionManager();
        this.eventManager = blade.eventManager();
        this.sessionKey = blade.environment().get("http.session.key", "SESSION");
        this.timeout = blade.environment().getInt("http.session.timeout", 1800);
    }

    public Session createSession(Request request) {
        Session session = this.getSession(request);
        Response response = WebContext.response();
        if (null == session) {
            return this.createSession(request, response);
        }
        if (session.expired() < Instant.now().getEpochSecond()) {
            this.removeSession(session);
        }
        return session;
    }

    private Session createSession(Request request, Response response) {
        long now = Instant.now().getEpochSecond();
        long expired = now + (long)this.timeout;
        String sessionId = UUID.UU32();
        Cookie cookie = new Cookie();
        cookie.name(this.sessionKey);
        cookie.value(sessionId);
        cookie.httpOnly(true);
        cookie.secure(request.isSecure());
        Session session = ReflectKit.newInstance(this.blade.sessionType());
        session.id(sessionId);
        session.created(now);
        session.expired(expired);
        this.sessionManager.addSession(session);
        request.cookie(cookie);
        response.cookie(cookie);
        this.eventManager.fireEvent(EventType.SESSION_CREATED, this.blade);
        return session;
    }

    private void removeSession(Session session) {
        session.attributes().clear();
        this.sessionManager.remove(session);
        this.eventManager.fireEvent(EventType.SESSION_DESTROY, this.blade);
    }

    private Session getSession(Request request) {
        String cookieHeader = request.cookie(this.sessionKey);
        if (null == cookieHeader) {
            return null;
        }
        return this.sessionManager.getSession(cookieHeader);
    }
}

