/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.WebSocketHandler;
import com.blade.mvc.websocket.WebSocketContext;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSockerHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger log = LoggerFactory.getLogger(WebSockerHandler.class);
    private WebSocketHandler webSocketHandler;
    private ExceptionHandler exceptionHandler;

    WebSockerHandler(Blade blade) {
        this.webSocketHandler = blade.webSocketHandler();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        WebSocketContext webSocketContext = new WebSocketContext(ctx);
        this.webSocketHandler.onConnect(webSocketContext);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        WebSocketContext webSocketContext = new WebSocketContext(ctx);
        this.webSocketHandler.onDisConnect(webSocketContext);
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        WebSocketContext webSocketContext = new WebSocketContext(ctx);
        if (!(frame instanceof TextWebSocketFrame)) {
            String message = "unsupported frame type: " + frame.getClass().getName();
            throw new UnsupportedOperationException(message);
        }
        String request = ((TextWebSocketFrame)frame).text();
        webSocketContext.setReqText(request);
        this.webSocketHandler.onText(webSocketContext);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (null != this.exceptionHandler) {
            this.exceptionHandler.handle((Exception)cause);
        } else {
            log.error("Blade Invoke Error", cause);
        }
        ctx.close();
    }
}

