/*
 * Decompiled with CFR 0.152.
 */
package com.blade.watcher;

import com.blade.Environment;
import com.blade.event.EventType;
import com.blade.mvc.Const;
import com.blade.mvc.WebContext;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentWatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentWatcher.class);

    @Override
    public void run() {
        Path path = Paths.get(Const.CLASSPATH, new String[0]);
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            WatchKey key;
            boolean valid;
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            do {
                key = watchService.take();
                for (WatchEvent<?> watchEvent : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<?> watchEventPath = watchEvent;
                    String filename = ((Path)watchEventPath.context()).toString();
                    if (log.isDebugEnabled()) {
                        log.debug("\u2b22 {} -> {}", kind, (Object)filename);
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE || !filename.startsWith(".app") || !filename.endsWith(".properties.swp")) continue;
                    log.info("\u2b22 Reload environment");
                    Environment environment = Environment.of("classpath:" + filename.substring(1, filename.length() - 4));
                    WebContext.blade().environment(environment);
                    WebContext.blade().eventManager().fireEvent(EventType.ENVIRONMENT_CHANGED, environment);
                }
            } while (valid = key.reset());
        }
        catch (IOException | InterruptedException ex) {
            log.error("Environment watch error", (Throwable)ex);
        }
    }
}

