/*
 * Decompiled with CFR 0.152.
 */
package com.blade.validator;

import com.blade.mvc.hook.Signature;
import com.blade.mvc.hook.WebHook;
import com.blade.validator.annotation.Email;
import com.blade.validator.annotation.Length;
import com.blade.validator.annotation.Max;
import com.blade.validator.annotation.Min;
import com.blade.validator.annotation.NotEmpty;
import com.blade.validator.annotation.NotNull;
import com.blade.validator.annotation.Url;
import com.blade.validator.annotation.Valid;
import com.blade.validator.exception.ValidateException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class ValidatorMiddleware
implements WebHook {
    private static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    public boolean before(Signature signature) {
        Object[] args = signature.getParameters();
        Method method = signature.getAction();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (null == parameter.getAnnotation(Valid.class)) continue;
            try {
                this.validate(args[i]);
                continue;
            }
            catch (ValidateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ValidateException(e.getMessage());
            }
        }
        return true;
    }

    private void validate(@NonNull Object object) throws IllegalAccessException {
        Field[] fields;
        if (object == null) {
            throw new NullPointerException("object");
        }
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            Url url;
            Email email;
            Min min;
            Max max;
            Length length;
            NotEmpty notEmpty;
            field.setAccessible(true);
            Object fieldValue = field.get(object);
            NotNull notNull = field.getAnnotation(NotNull.class);
            if (null != notNull) {
                this.validateNotNull(notNull.message(), fieldValue);
            }
            if (null != (notEmpty = field.getAnnotation(NotEmpty.class))) {
                this.validateNotEmpty(notEmpty.message(), fieldValue);
            }
            if (null != (length = field.getAnnotation(Length.class))) {
                this.validateLength(length, fieldValue);
            }
            if (null != (max = field.getAnnotation(Max.class))) {
                this.validateMax(max, fieldValue);
            }
            if (null != (min = field.getAnnotation(Min.class))) {
                this.validateMin(min, fieldValue);
            }
            if (null != (email = field.getAnnotation(Email.class))) {
                this.validateEmail(email, fieldValue);
            }
            if (null == (url = field.getAnnotation(Url.class))) continue;
            this.validateUrl(url, fieldValue);
        }
    }

    private void validateUrl(Url url, Object fieldValue) {
        String regex;
        if (null != fieldValue && !Pattern.matches(regex = "(https?://(w{3}\\.)?)?\\w+\\.\\w+(\\.[a-zA-Z]+)*(:\\d{1,5})?(/\\w*)*(\\??(.+=.*)?(&.+=.*)?)?", fieldValue.toString())) {
            throw new ValidateException(url.message());
        }
    }

    public void validateNotNull(String msg, Object val) {
        if (null == val) {
            throw new ValidateException(msg);
        }
    }

    public void validateNotEmpty(String msg, Object val) {
        if (null == val) {
            throw new ValidateException(msg);
        }
        if (val instanceof String && val.toString().isEmpty()) {
            throw new ValidateException(msg);
        }
    }

    public void validateLength(Length length, Object val) {
        if (null != val) {
            if (val.toString().length() > length.max()) {
                String msg = String.format(length.message(), length.max());
                throw new ValidateException(msg);
            }
            if (val.toString().length() < length.min()) {
                String msg = String.format(length.message(), length.min());
                throw new ValidateException(msg);
            }
        }
    }

    public void validateMax(Max max, Object val) {
        Double d;
        if (null != max && null != val && (d = Double.valueOf(val.toString())) > max.value()) {
            String msg = String.format(max.message(), max.value());
            throw new ValidateException(msg);
        }
    }

    public void validateMin(Min min, Object val) {
        Double d;
        if (null != min && null != val && (d = Double.valueOf(val.toString())) < min.value()) {
            String msg = String.format(min.message(), min.value());
            throw new ValidateException(msg);
        }
    }

    public void validateEmail(Email email, Object val) {
        Matcher matcher;
        if (null != val && !(matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(val.toString())).find()) {
            throw new ValidateException(email.message());
        }
    }
}

