/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.annotation;

import com.blazebit.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationUtil {
    private static Class<? extends Annotation> stereotypeAnnotationClass;

    public static Set<Annotation> getAllAnnotations(Class<?> clazz) {
        HashSet<Annotation> annotationSet = new HashSet<Annotation>();
        Stack<Class<? extends Annotation>> annotationTypes = new Stack<Class<? extends Annotation>>();
        for (Class<?> type : ReflectionUtil.getSuperTypes(clazz)) {
            Annotation[] annotations;
            for (Annotation a : annotations = type.getAnnotations()) {
                annotationSet.add(a);
                annotationTypes.push(a.annotationType());
            }
        }
        while (!annotationTypes.isEmpty()) {
            Class annotationType = (Class)annotationTypes.pop();
            if (stereotypeAnnotationClass == null || !annotationType.isAnnotationPresent(stereotypeAnnotationClass)) continue;
            for (Annotation annotation : annotationType.getAnnotations()) {
                annotationTypes.push(annotation.annotationType());
                if (annotation.annotationType().equals(stereotypeAnnotationClass)) continue;
                annotationSet.add(annotation);
            }
        }
        return annotationSet;
    }

    public static Set<Annotation> getAllAnnotations(Method m) {
        HashSet<Annotation> annotationSet = new HashSet<Annotation>();
        Annotation[] annotations = m.getAnnotations();
        Stack<Class<? extends Annotation>> annotationTypes = new Stack<Class<? extends Annotation>>();
        for (Annotation a : annotations) {
            annotationSet.add(a);
            annotationTypes.push(a.annotationType());
        }
        while (!annotationTypes.isEmpty()) {
            Class annotationType = (Class)annotationTypes.pop();
            if (stereotypeAnnotationClass == null || !annotationType.isAnnotationPresent(stereotypeAnnotationClass)) continue;
            for (Annotation annotation : annotationType.getAnnotations()) {
                annotationTypes.push(annotation.annotationType());
                if (annotation.annotationType().equals(stereotypeAnnotationClass)) continue;
                annotationSet.add(annotation);
            }
        }
        return annotationSet;
    }

    public static <T extends Annotation> T findAnnotation(Method m, Class<?> clazz, Class<T> annotationClazz) {
        T result = AnnotationUtil.findAnnotation(m, annotationClazz);
        return result != null ? result : AnnotationUtil.findAnnotation(clazz, annotationClazz);
    }

    public static <T extends Annotation> T findAnnotation(Method m, Class<T> annotationClazz) {
        Stack<Class<? extends Annotation>> annotationTypes = new Stack<Class<? extends Annotation>>();
        for (Annotation a : m.getAnnotations()) {
            if (a.annotationType().equals(annotationClazz)) {
                return (T)((Annotation)annotationClazz.cast(a));
            }
            annotationTypes.push(a.annotationType());
        }
        while (!annotationTypes.isEmpty()) {
            Class annotationType = (Class)annotationTypes.pop();
            if (stereotypeAnnotationClass == null || !annotationType.isAnnotationPresent(stereotypeAnnotationClass)) continue;
            for (Annotation annotation : annotationType.getAnnotations()) {
                if (!annotation.annotationType().equals(stereotypeAnnotationClass) && annotation.annotationType().equals(annotationClazz)) {
                    return (T)((Annotation)annotationClazz.cast(annotation));
                }
                annotationTypes.push(annotation.annotationType());
            }
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClazz) {
        Stack<Class<? extends Annotation>> annotationTypes = new Stack<Class<? extends Annotation>>();
        for (Class<?> type : ReflectionUtil.getSuperTypes(clazz)) {
            Annotation[] annotations;
            for (Annotation a : annotations = type.getAnnotations()) {
                if (a.annotationType().equals(annotationClazz)) {
                    return (T)((Annotation)annotationClazz.cast(a));
                }
                annotationTypes.push(a.annotationType());
            }
        }
        while (!annotationTypes.isEmpty()) {
            Class annotationType = (Class)annotationTypes.pop();
            if (stereotypeAnnotationClass == null || !annotationType.isAnnotationPresent(stereotypeAnnotationClass)) continue;
            for (Annotation annotation : annotationType.getAnnotations()) {
                if (!annotation.annotationType().equals(stereotypeAnnotationClass) && annotation.annotationType().equals(annotationClazz)) {
                    return (T)((Annotation)annotationClazz.cast(annotation));
                }
                annotationTypes.push(annotation.annotationType());
            }
        }
        return null;
    }

    static {
        try {
            stereotypeAnnotationClass = Class.forName("javax.enterprise.inject.Stereotype");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AnnotationUtil.class.getName()).log(Level.WARNING, "Stereotype annotation can not be found, skipping annotation inheritance via stereotype.", ex);
        }
    }
}

