/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.comparator;

import com.blazebit.comparator.GenericComparator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenericCollectionComparator<T>
extends GenericComparator<T> {
    private int index;

    public GenericCollectionComparator(String field, int index) {
        super(field);
        this.index = index;
    }

    @Override
    public int compare(T object1, T object2) {
        if (object1 == null || object2 == null) {
            return this.compareNullObjects(object1, object2);
        }
        return super.compare(GenericCollectionComparator.get(object1, this.index), GenericCollectionComparator.get(object2, this.index));
    }

    private static Object get(Object object, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return GenericCollectionComparator.get(iterator, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[index];
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                if (--index == -1) {
                    return it.next();
                }
                it.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return GenericCollectionComparator.get(iterator, index);
        }
        if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                if (--index == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, index);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }
}

