/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.comparator;

import com.blazebit.reflection.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Comparator;

public class GenericComparator<T>
implements Comparator<T> {
    protected String field;

    public GenericComparator(String field) {
        this.field = field;
    }

    @Override
    public int compare(T object1, T object2) {
        try {
            if (this.field == null) {
                throw new IllegalArgumentException("Field must not be null !!!");
            }
            if (object1 == null || object2 == null) {
                return this.compareNullObjects(object1, object2);
            }
            Method method1 = ReflectionUtil.getGetter(object1.getClass(), this.field);
            Method method2 = ReflectionUtil.getGetter(object2.getClass(), this.field);
            Object value1 = method1.invoke(object1, new Object[0]);
            Object value2 = method2.invoke(object2, new Object[0]);
            if (value1 == null || value2 == null) {
                return this.compareNullObjects(value1, value2);
            }
            if (!(value1 instanceof Comparable)) {
                throw new IllegalArgumentException("Type '" + value1.getClass().getName() + "' is not comparable.");
            }
            return ((Comparable)value1).compareTo(value2);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not compare !!!", e);
        }
    }

    protected Integer compareNullObjects(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return 0;
        }
        if (object1 == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        return 0;
    }
}

