/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LazyGetterMethod {
    private Object source;
    private String[] fieldNames;

    public LazyGetterMethod(Object source, String fieldNames) {
        this(source, fieldNames.split("\\."));
    }

    public LazyGetterMethod(Object source, String[] fieldNames) {
        if (source == null) {
            throw new NullPointerException("target");
        }
        this.source = source;
        this.fieldNames = fieldNames;
    }

    public Object invoke() throws InvocationTargetException, IllegalAccessException {
        Object current = this.source;
        for (String fieldName : this.fieldNames) {
            Method m = ReflectionUtil.getGetter(current.getClass(), fieldName);
            current = m.invoke(current, new Object[0]);
        }
        return current;
    }
}

