/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.LazyGetterMethod;
import com.blazebit.reflection.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;

public class LazySetterMethod {
    private Object target;
    private String[] fieldNames;
    private Object[] args;

    public LazySetterMethod(Object target, String fieldNames, Object ... args) {
        this(target, fieldNames.split("\\."), args);
    }

    public LazySetterMethod(Object target, String[] fieldNames, Object ... args) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        this.target = target;
        this.fieldNames = fieldNames;
        this.args = args;
    }

    public LazySetterMethod(Object target, String fieldNames, LazyGetterMethod ... args) {
        this(target, fieldNames.split("\\."), (Object[])args);
    }

    public LazySetterMethod(Object target, String[] fieldNames, LazyGetterMethod ... args) {
        this(target, fieldNames, (Object[])args);
    }

    public void invoke() throws InvocationTargetException, IllegalAccessException {
        Object[] actualArgs = new Object[this.args.length];
        for (int i = 0; i < actualArgs.length; ++i) {
            actualArgs[i] = this.args[i];
            if (!(actualArgs[i] instanceof LazyGetterMethod)) continue;
            actualArgs[i] = ((LazyGetterMethod)actualArgs[i]).invoke();
        }
        String fieldName = this.fieldNames[this.fieldNames.length - 1];
        Object targetObject = this.target;
        if (this.fieldNames.length > 1) {
            String[] getFieldNames = new String[this.fieldNames.length - 1];
            System.arraycopy(this.fieldNames, 0, getFieldNames, 0, this.fieldNames.length - 1);
            targetObject = new LazyGetterMethod(targetObject, getFieldNames).invoke();
        }
        ReflectionUtil.getSetter(targetObject.getClass(), fieldName).invoke(targetObject, actualArgs);
    }
}

