/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class MethodException {
    private Constructor<?> constructor;
    private Method method;
    private int index;

    MethodException(Method method, int index) {
        if (method == null) {
            throw new NullPointerException("Method must not be null");
        }
        this.method = method;
        this.index = index;
    }

    MethodException(Constructor<?> constructor, int index) {
        if (constructor == null) {
            throw new NullPointerException("Method must not be null");
        }
        this.constructor = constructor;
        this.index = index;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getType() {
        return this.method != null ? this.method.getExceptionTypes()[this.index] : this.constructor.getExceptionTypes()[this.index];
    }

    public Class<?> getResolvedType(Class<?> concreteClass) {
        Type t;
        Type type = t = this.method != null ? this.method.getGenericExceptionTypes()[this.index] : this.constructor.getGenericExceptionTypes()[this.index];
        if (t instanceof TypeVariable) {
            return ReflectionUtil.resolveTypeVariable(concreteClass, (TypeVariable)t);
        }
        return this.getType();
    }

    public Class<?>[] getResolvedTypeParameters(Class<?> concreteClass) {
        Type t = this.method != null ? this.method.getGenericExceptionTypes()[this.index] : this.constructor.getGenericExceptionTypes()[this.index];
        return ReflectionUtil.resolveTypeArguments(concreteClass, t);
    }

    public Method getMethod() {
        return this.method;
    }
}

