/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class MethodParameter {
    private Constructor<?> constructor;
    private Method method;
    private int index;

    MethodParameter(Method method, int index) {
        if (method == null) {
            throw new NullPointerException("Method must not be null");
        }
        this.method = method;
        this.index = index;
    }

    MethodParameter(Constructor<?> constructor, int index) {
        if (constructor == null) {
            throw new NullPointerException("Method must not be null");
        }
        this.constructor = constructor;
        this.index = index;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getType() {
        return this.method != null ? this.method.getParameterTypes()[this.index] : this.constructor.getParameterTypes()[this.index];
    }

    public Class<?> getResolvedType(Class<?> concreteClass) {
        Type t;
        Type type = t = this.method != null ? this.method.getGenericParameterTypes()[this.index] : this.constructor.getGenericParameterTypes()[this.index];
        if (t instanceof TypeVariable) {
            return ReflectionUtil.resolveTypeVariable(concreteClass, (TypeVariable)t);
        }
        return this.getType();
    }

    public Class<?>[] getResolvedTypeParameters(Class<?> concreteClass) {
        Type t = this.method != null ? this.method.getGenericParameterTypes()[this.index] : this.constructor.getGenericParameterTypes()[this.index];
        return ReflectionUtil.resolveTypeArguments(concreteClass, t);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("annotationClass must not be null");
        }
        for (Annotation a : this.getAnnotations()) {
            if (!annotationClass.isInstance(a)) continue;
            return (T)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.method != null ? this.method.getParameterAnnotations()[this.index] : this.constructor.getParameterAnnotations()[this.index];
    }

    public Method getMethod() {
        return this.method;
    }
}

