/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.MethodException;
import com.blazebit.reflection.MethodParameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ReflectionUtil {
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();
    private static final Map<Class<?>, Class<?>> primitiveToObjectClasses = new HashMap();

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        Class<?> clazz = primitiveClasses.get(className);
        if (clazz == null) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static Class<?> getObjectClassOfPrimitve(Class<?> primitive) {
        if (primitiveToObjectClasses.containsKey(primitive)) {
            return primitiveToObjectClasses.get(primitive);
        }
        return primitive;
    }

    public static boolean isSubtype(Class<?> targetClazz, Class<?> superType) {
        Class<?> traverseClass = targetClazz;
        do {
            if (traverseClass.equals(superType)) {
                return true;
            }
            for (Class<?> c : traverseClass.getInterfaces()) {
                if (!superType.equals(c)) continue;
                return true;
            }
        } while ((traverseClass = traverseClass.getSuperclass()) != null);
        return false;
    }

    public static Set<Class<?>> getSuperTypes(Class<?> clazz) {
        LinkedHashSet list = new LinkedHashSet();
        Class<?> traverseClass = clazz;
        do {
            list.add(traverseClass);
            Collections.addAll(list, traverseClass.getInterfaces());
        } while ((traverseClass = traverseClass.getSuperclass()) != null);
        return list;
    }

    public static Class<?> getFieldType(Class<?> clazz, String fieldName) {
        Field f = ReflectionUtil.getField(clazz, fieldName);
        if (f == null) {
            return null;
        }
        return f.getType();
    }

    public static Class<?> getResolvedFieldType(Class<?> clazz, String fieldName) {
        return ReflectionUtil.getResolvedFieldType(clazz, ReflectionUtil.getField(clazz, fieldName));
    }

    public static Class<?> getResolvedFieldType(Class<?> clazz, Field f) {
        if (f == null) {
            return null;
        }
        if (f.getGenericType() instanceof TypeVariable) {
            return ReflectionUtil.resolveTypeVariable(clazz, (TypeVariable)f.getGenericType());
        }
        return f.getType();
    }

    public static Class<?>[] getResolvedFieldTypeArguments(Class<?> clazz, String fieldName) {
        return ReflectionUtil.getResolvedFieldTypeArguments(clazz, ReflectionUtil.getField(clazz, fieldName));
    }

    public static Class<?>[] getResolvedFieldTypeArguments(Class<?> clazz, Field f) {
        if (f == null) {
            return null;
        }
        return ReflectionUtil.resolveTypeArguments(clazz, f.getGenericType());
    }

    public static Class<?>[] resolveTypeArguments(Class<?> concreteClass, Type type) {
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.resolveTypeArguments(concreteClass, (ParameterizedType)type);
        }
        return new Class[0];
    }

    public static Class<?>[] resolveTypeArguments(Class<?> concreteClass, ParameterizedType parameterizedType) {
        if (parameterizedType == null) {
            return null;
        }
        Type[] argumentTypes = parameterizedType.getActualTypeArguments();
        Class[] resolvedClasses = new Class[argumentTypes.length];
        for (int i = 0; i < argumentTypes.length; ++i) {
            resolvedClasses[i] = argumentTypes[i] instanceof TypeVariable ? ReflectionUtil.resolveTypeVariable(concreteClass, (TypeVariable)argumentTypes[i]) : (Class)argumentTypes[i];
        }
        return resolvedClasses;
    }

    public static Class<?> resolveTypeVariable(Class<?> concreteClass, TypeVariable<?> typeVariable) {
        Class<Object> classThatContainsTypeVariable = null;
        if (ReflectionUtil.isSubtype(typeVariable.getGenericDeclaration().getClass(), Class.class)) {
            classThatContainsTypeVariable = (Class<?>)typeVariable.getGenericDeclaration();
        } else if (ReflectionUtil.isSubtype(typeVariable.getGenericDeclaration().getClass(), Method.class)) {
            classThatContainsTypeVariable = ((Method)typeVariable.getGenericDeclaration()).getDeclaringClass();
        } else if (ReflectionUtil.isSubtype(typeVariable.getGenericDeclaration().getClass(), Constructor.class)) {
            classThatContainsTypeVariable = ((Constructor)typeVariable.getGenericDeclaration()).getDeclaringClass();
        }
        if (!ReflectionUtil.isSubtype(concreteClass, classThatContainsTypeVariable)) {
            throw new IllegalArgumentException("The given concrete class is not a subtype of the class that contain the type variable!");
        }
        int position = ReflectionUtil.getTypeVariablePosition(typeVariable);
        if (position == -1) {
            throw new IllegalArgumentException("Type variable not found in its container class!");
        }
        Stack classStack = new Stack();
        Class<?> currentClass = concreteClass;
        Type resolvedType = typeVariable;
        classStack.push(currentClass);
        while (!currentClass.getSuperclass().equals(typeVariable.getGenericDeclaration())) {
            currentClass = currentClass.getSuperclass();
            classStack.push(currentClass);
        }
        while (!classStack.isEmpty() && !(resolvedType instanceof Class)) {
            Class classToInspect = (Class)classStack.pop();
            Type classToInspectType = classToInspect.getGenericSuperclass();
            if (!(classToInspectType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Could not resolve type");
            }
            ParameterizedType parameterizedClassToInspect = (ParameterizedType)classToInspectType;
            if (parameterizedClassToInspect.getActualTypeArguments().length < position + 1) {
                throw new IllegalArgumentException("Could not resolve type");
            }
            resolvedType = parameterizedClassToInspect.getActualTypeArguments()[position];
            if (!(resolvedType instanceof TypeVariable)) continue;
            position = ReflectionUtil.getTypeVariablePosition(classToInspect, resolvedType);
        }
        if (!(resolvedType instanceof Class)) {
            throw new IllegalArgumentException("Could not resolve type");
        }
        return (Class)resolvedType;
    }

    public static int getTypeVariablePosition(TypeVariable<?> typeVariable) {
        return ReflectionUtil.getTypeVariablePosition(typeVariable.getGenericDeclaration(), typeVariable);
    }

    public static int getTypeVariablePosition(GenericDeclaration genericDeclartion, TypeVariable<?> typeVariable) {
        int position = -1;
        TypeVariable<?>[] typeVariableDeclarationParameters = genericDeclartion.getTypeParameters();
        for (int i = 0; i < typeVariableDeclarationParameters.length; ++i) {
            if (!typeVariableDeclarationParameters[i].equals(typeVariable)) continue;
            position = i;
            break;
        }
        return position;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        for (Class<?> traverseClass = clazz; traverseClass != null; traverseClass = traverseClass.getSuperclass()) {
            try {
                return traverseClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ex1) {
                for (Class<?> interfaceClass : traverseClass.getInterfaces()) {
                    try {
                        return interfaceClass.getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException ex2) {
                    }
                }
                continue;
            }
        }
        return null;
    }

    public static Class<?> getMethodReturnType(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtil.getMethod(clazz, methodName, parameterTypes);
        if (m == null) {
            return null;
        }
        return m.getReturnType();
    }

    public static Class<?>[] getMethodParameterTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtil.getMethod(clazz, methodName, parameterTypes);
        if (m == null) {
            return null;
        }
        return m.getParameterTypes();
    }

    public static Class<?>[] getMethodExceptionTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtil.getMethod(clazz, methodName, parameterTypes);
        if (m == null) {
            return null;
        }
        return m.getExceptionTypes();
    }

    public static Class<?> getResolvedMethodReturnType(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.getResolvedMethodReturnType(clazz, ReflectionUtil.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?> getResolvedMethodReturnType(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        if (m.getGenericReturnType() instanceof TypeVariable) {
            return ReflectionUtil.resolveTypeVariable(clazz, (TypeVariable)m.getGenericReturnType());
        }
        return m.getReturnType();
    }

    public static Class<?>[] getResolvedMethodReturnTypeArguments(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.getResolvedMethodReturnTypeArguments(clazz, ReflectionUtil.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?>[] getResolvedMethodReturnTypeArguments(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        return ReflectionUtil.resolveTypeArguments(clazz, m.getGenericReturnType());
    }

    public static Class<?>[] getResolvedMethodParameterTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.getResolvedMethodParameterTypes(clazz, ReflectionUtil.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?>[] getResolvedMethodParameterTypes(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] genericParameterTypes = m.getGenericParameterTypes();
        Class[] parameterTypes = new Class[genericParameterTypes.length];
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            parameterTypes[i] = genericParameterTypes[i] instanceof TypeVariable ? ReflectionUtil.resolveTypeVariable(clazz, (TypeVariable)genericParameterTypes[i]) : (Class)genericParameterTypes[i];
        }
        return parameterTypes;
    }

    public static Class<?>[] getResolvedMethodExceptionTypes(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.getResolvedMethodExceptionTypes(clazz, ReflectionUtil.getMethod(clazz, methodName, parameterTypes));
    }

    public static Class<?>[] getResolvedMethodExceptionTypes(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] genericExceptionTypes = m.getGenericExceptionTypes();
        Class[] exceptionTypes = new Class[genericExceptionTypes.length];
        for (int i = 0; i < genericExceptionTypes.length; ++i) {
            exceptionTypes[i] = genericExceptionTypes[i] instanceof TypeVariable ? ReflectionUtil.resolveTypeVariable(clazz, (TypeVariable)genericExceptionTypes[i]) : (Class)genericExceptionTypes[i];
        }
        return exceptionTypes;
    }

    public static MethodParameter[] getMethodParameters(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.getMethodParameters(clazz, ReflectionUtil.getMethod(clazz, methodName, parameterTypes));
    }

    public static MethodParameter[] getMethodParameters(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] exceptionTypes = m.getGenericExceptionTypes();
        MethodParameter[] methodParameters = new MethodParameter[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            methodParameters[i] = new MethodParameter(m, i);
        }
        return methodParameters;
    }

    public static MethodException[] getMethodExceptions(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.getMethodExceptions(clazz, ReflectionUtil.getMethod(clazz, methodName, parameterTypes));
    }

    public static MethodException[] getMethodExceptions(Class<?> clazz, Method m) {
        if (m == null) {
            return null;
        }
        Type[] exceptionTypes = m.getGenericExceptionTypes();
        MethodException[] methodExceptions = new MethodException[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            methodExceptions[i] = new MethodException(m, i);
        }
        return methodExceptions;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> traverseClass = clazz; traverseClass != null; traverseClass = traverseClass.getSuperclass()) {
            try {
                return traverseClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex1) {
                for (Class<?> interfaceClass : traverseClass.getInterfaces()) {
                    try {
                        return interfaceClass.getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException ex2) {
                    }
                }
                continue;
            }
        }
        return null;
    }

    public static Method getGetter(Class<?> clazz, String fieldName) {
        StringBuilder sb = new StringBuilder("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName, 1, fieldName.length());
        Method m = ReflectionUtil.getMethod(clazz, sb.toString(), new Class[0]);
        if (m == null) {
            sb.replace(0, 3, "is");
            m = ReflectionUtil.getMethod(clazz, sb.toString(), new Class[0]);
        }
        if (!ReflectionUtil.isGetter(m)) {
            return null;
        }
        return m;
    }

    private static boolean isGetter(Method m) {
        return m != null && !Void.TYPE.equals(m.getReturnType()) && m.getParameterTypes().length == 0;
    }

    public static Method getSetter(Class<?> clazz, String fieldName) {
        StringBuilder sb = new StringBuilder("set").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName, 1, fieldName.length());
        String methodName = sb.toString();
        Method method = null;
        for (Class<?> traverseClass = clazz; traverseClass != null && (method = ReflectionUtil.findSetter(methodName, traverseClass)) == null && (method = ReflectionUtil.findSetter(methodName, traverseClass.getInterfaces())) == null; traverseClass = traverseClass.getSuperclass()) {
        }
        return method;
    }

    private static Method findSetter(String methodName, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(methodName) || !ReflectionUtil.isSetter(m)) continue;
                return m;
            }
        }
        return null;
    }

    private static boolean isSetter(Method m) {
        return m != null && m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 1;
    }

    static {
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("void", Void.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveToObjectClasses.put(Integer.TYPE, Integer.class);
        primitiveToObjectClasses.put(Long.TYPE, Long.class);
        primitiveToObjectClasses.put(Double.TYPE, Double.class);
        primitiveToObjectClasses.put(Float.TYPE, Float.class);
        primitiveToObjectClasses.put(Boolean.TYPE, Boolean.class);
        primitiveToObjectClasses.put(Character.TYPE, Character.class);
        primitiveToObjectClasses.put(Byte.TYPE, Byte.class);
        primitiveToObjectClasses.put(Void.TYPE, Void.class);
        primitiveToObjectClasses.put(Short.TYPE, Short.class);
    }
}

