/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.text;

import com.blazebit.text.AbstractFormat;
import com.blazebit.text.ParserContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;

public class CalendarFormat
extends AbstractFormat<Calendar> {
    private static final long serialVersionUID = 1L;

    public CalendarFormat() {
        super(Calendar.class);
    }

    @Override
    public Calendar parse(String value, ParserContext context) {
        Calendar calendar = Calendar.getInstance();
        DateFormat o = null;
        if (context != null) {
            context.getAttribute("format");
            if (o != null && !(o instanceof DateFormat)) {
                throw new IllegalArgumentException("Illegal format object in context");
            }
        }
        if (o == null) {
            o = DateFormat.getDateTimeInstance();
        }
        try {
            calendar.setTime(o.parse(value));
            return calendar;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    public String format(Calendar value, ParserContext context) {
        Object o = null;
        if (context != null && (o = context.getAttribute("format")) != null && !(o instanceof DateFormat)) {
            throw new IllegalArgumentException("Illegal format object in context");
        }
        if (o == null) {
            o = DateFormat.getDateTimeInstance();
        }
        return ((DateFormat)o).format(value.getTime());
    }
}

