/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.text;

import com.blazebit.text.BigDecimalFormat;
import com.blazebit.text.BooleanFormat;
import com.blazebit.text.ByteFormat;
import com.blazebit.text.CalendarFormat;
import com.blazebit.text.CharacterFormat;
import com.blazebit.text.ClassFormat;
import com.blazebit.text.CurrencyFormat;
import com.blazebit.text.DateFormat;
import com.blazebit.text.DoubleFormat;
import com.blazebit.text.FloatFormat;
import com.blazebit.text.IntegerFormat;
import com.blazebit.text.LocaleFormat;
import com.blazebit.text.LongFormat;
import com.blazebit.text.ParserContext;
import com.blazebit.text.SerializableFormat;
import com.blazebit.text.ShortFormat;
import com.blazebit.text.StringFormat;
import com.blazebit.text.TimeZoneFormat;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class FormatUtil {
    private static final Map<Class<?>, SerializableFormat<?>> parseableTypes = new HashMap();

    public static Map<Class<?>, SerializableFormat<?>> getAvailableFormatters() {
        return Collections.unmodifiableMap(parseableTypes);
    }

    public static boolean isParseableType(Class<?> type) {
        return parseableTypes.containsKey(type);
    }

    public static Serializable getParsedValue(Class<?> returnType, String value) throws ParseException {
        return FormatUtil.getParsedValue(returnType, value, java.text.DateFormat.getDateTimeInstance());
    }

    public static Serializable getParsedValue(Class<?> returnType, String value, java.text.DateFormat dateFormatter) throws ParseException {
        SerializableFormat<?> formatter = parseableTypes.get(returnType);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown return type");
        }
        ParserContextImpl ctx = new ParserContextImpl();
        ctx.setAttribute("format", dateFormatter);
        return formatter.parse(value, ctx);
    }

    static {
        parseableTypes.put(Integer.TYPE, new IntegerFormat());
        parseableTypes.put(Long.TYPE, new LongFormat());
        parseableTypes.put(Double.TYPE, new DoubleFormat());
        parseableTypes.put(Float.TYPE, new FloatFormat());
        parseableTypes.put(Boolean.TYPE, new BooleanFormat());
        parseableTypes.put(Character.TYPE, new CharacterFormat());
        parseableTypes.put(Byte.TYPE, new ByteFormat());
        parseableTypes.put(Short.TYPE, new ShortFormat());
        parseableTypes.put(Integer.class, new IntegerFormat());
        parseableTypes.put(Long.class, new LongFormat());
        parseableTypes.put(Double.class, new DoubleFormat());
        parseableTypes.put(Float.class, new FloatFormat());
        parseableTypes.put(Boolean.class, new BooleanFormat());
        parseableTypes.put(Character.class, new CharacterFormat());
        parseableTypes.put(Byte.class, new ByteFormat());
        parseableTypes.put(Short.class, new ShortFormat());
        parseableTypes.put(String.class, new StringFormat());
        parseableTypes.put(BigDecimal.class, new BigDecimalFormat());
        parseableTypes.put(Date.class, new DateFormat());
        parseableTypes.put(Calendar.class, new CalendarFormat());
        parseableTypes.put(Locale.class, new LocaleFormat());
        parseableTypes.put(TimeZone.class, new TimeZoneFormat());
        parseableTypes.put(Currency.class, new CurrencyFormat());
        parseableTypes.put(Class.class, new ClassFormat());
    }

    private static class ParserContextImpl
    implements ParserContext {
        private final Map<String, Object> contextMap = new HashMap<String, Object>();

        private ParserContextImpl() {
        }

        @Override
        public Object getAttribute(String name) {
            return this.contextMap.get(name);
        }

        public void setAttribute(String name, Object value) {
            this.contextMap.put(name, value);
        }
    }
}

