/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.cdi;

import com.blazebit.annotation.AnnotationUtil;
import com.blazebit.cdi.cleanup.annotation.Cleanup;
import com.blazebit.exception.ExceptionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;

public abstract class AbstractExceptionHandlerInterceptor<T extends Annotation, V extends Annotation, M extends Enum<M>> {
    private Class<T> clazz;
    private M defaultMessage;
    private Class<V> defaultMessageAnnotation;

    public AbstractExceptionHandlerInterceptor() {
    }

    public AbstractExceptionHandlerInterceptor(Class<T> clazz, M defaultMessage, Class<V> defaultMessageAnnotation) {
        this.clazz = clazz;
        this.defaultMessage = defaultMessage;
        this.defaultMessageAnnotation = defaultMessageAnnotation;
    }

    public Object handleError(InvocationContext ic) throws Exception {
        Object ret;
        block5: {
            Object targetObj = ic.getTarget();
            ret = null;
            if (ic.getMethod().isAnnotationPresent(Cleanup.class)) {
                return ic.proceed();
            }
            try {
                ret = ic.proceed();
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ExceptionUtil.unwrapInvocationTargetException((Throwable)((InvocationTargetException)t));
                }
                if (this.handleException(ic.getMethod().getAnnotation(this.clazz), ic, targetObj, t) || this.handleException(AnnotationUtil.findAnnotation(targetObj.getClass(), this.clazz), ic, targetObj, t)) break block5;
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new Exception(t);
            }
        }
        return ret;
    }

    private boolean handleException(T handler, InvocationContext ic, Object targetObj, Throwable t) throws Exception {
        Object[] handlings = null;
        if (handler != null) {
            handlings = (Object[])this.clazz.getMethod("value", new Class[0]).invoke(handler, new Object[0]);
            if (t instanceof InvocationTargetException) {
                t = ExceptionUtil.unwrapInvocationTargetException((Throwable)((InvocationTargetException)t));
            }
            for (Object exHandle : handlings) {
                boolean invokedByException;
                V messageAnnotaion;
                if (!t.getClass().equals((Class)exHandle.getClass().getMethod("exception", new Class[0]).invoke(exHandle, new Object[0]))) continue;
                Enum message = (Enum)exHandle.getClass().getMethod("message", new Class[0]).invoke(exHandle, new Object[0]);
                if (message == this.defaultMessage && (messageAnnotaion = t.getClass().getAnnotation(this.defaultMessageAnnotation)) != null) {
                    message = (Enum)messageAnnotaion.getClass().getMethod("value", new Class[0]).invoke(messageAnnotaion, new Object[0]);
                }
                if (!(invokedByException = this.invokeCleanups(ic.getMethod().getDeclaringClass(), targetObj, (String)exHandle.getClass().getMethod("cleanupName", new Class[0]).invoke(exHandle, new Object[0])))) {
                    this.invokeCleanups(ic.getMethod().getDeclaringClass(), targetObj, (String)handler.getClass().getMethod("cleanupName", new Class[0]).invoke(handler, new Object[0]));
                }
                this.handleException(t, message);
                return true;
            }
        }
        return false;
    }

    private boolean invokeCleanups(Class<?> clazz, Object target, String cleanupName) throws Exception {
        boolean invoked = false;
        if (!cleanupName.isEmpty()) {
            for (Method m : clazz.getMethods()) {
                Cleanup cleanup = m.getAnnotation(Cleanup.class);
                if (cleanup == null || !cleanup.value().equals(cleanupName)) continue;
                m.invoke(target, new Object[0]);
                invoked = true;
            }
        }
        return invoked;
    }

    protected abstract void handleException(Throwable var1, Enum<M> var2);
}

