/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.cdi;

import com.blazebit.cdi.DefaultLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CdiUtil {
    private static final Logger log = Logger.getLogger(CdiUtil.class.getName());

    public static BeanManager getBeanManager() {
        try {
            InitialContext initialContext = new InitialContext();
            return (BeanManager)initialContext.lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            log.log(Level.SEVERE, "Couldn't get BeanManager through JNDI", e);
            return null;
        }
    }

    public static <T> T getBean(String name) {
        BeanManager bm = CdiUtil.getBeanManager();
        Bean bean = (Bean)bm.getBeans(name).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        return (T)bm.getReference(bean, (Type)bean.getBeanClass(), ctx);
    }

    public static <T> T getBean(Class<T> clazz) {
        return CdiUtil.getBean(CdiUtil.getBeanManager(), clazz);
    }

    public static <T> T getBean(BeanManager bm, Class<T> clazz) {
        return CdiUtil.getBean(bm, clazz, (Annotation[])null);
    }

    public static <T> T getBean(Class<T> clazz, Annotation ... annotations) {
        return CdiUtil.getBean(CdiUtil.getBeanManager(), clazz, annotations);
    }

    public static <T> T getBean(BeanManager bm, Class<T> clazz, Annotation ... annotations) {
        Bean bean = annotations != null ? (Bean)bm.getBeans(clazz, annotations).iterator().next() : (Bean)bm.getBeans(clazz, new Annotation[]{new DefaultLiteral()}).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        return (T)bm.getReference(bean, (Type)bean.getBeanClass(), ctx);
    }
}

