/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.cdi.cleanup;

import com.blazebit.annotation.AnnotationUtil;
import com.blazebit.annotation.constraint.NullClass;
import com.blazebit.cdi.cleanup.annotation.Cleanup;
import com.blazebit.cdi.cleanup.annotation.CleanupHandler;
import com.blazebit.cdi.cleanup.annotation.CleanupHandling;
import com.blazebit.exception.ExceptionUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@CleanupHandler(cleanup=NullClass.class)
public class CleanupHandlerInterceptor
implements Serializable {
    private static final long serialVersionUID = 2640134717545764135L;

    @AroundInvoke
    public Object cleanup(InvocationContext ic) throws Exception {
        Object targetObject;
        Class<?> targetClass;
        Object ret = null;
        Method m = ic.getMethod();
        CleanupHandler cleanupHandlerAnnotation = (CleanupHandler)AnnotationUtil.findAnnotation((Method)m, targetClass = (targetObject = ic.getTarget()) == null ? m.getDeclaringClass() : targetObject.getClass(), CleanupHandler.class);
        if (cleanupHandlerAnnotation == null) {
            throw new IllegalStateException("The interceptor annotation can not be determined!");
        }
        if (ic.getMethod().isAnnotationPresent(Cleanup.class)) {
            return ic.proceed();
        }
        try {
            ret = ic.proceed();
        }
        catch (Throwable t) {
            Throwable t1 = ExceptionUtil.unwrapInvocationTargetException((Throwable)t);
            this.handleCleanups(targetObject, cleanupHandlerAnnotation, t1);
            if (t1 instanceof Exception) {
                throw (Exception)t1;
            }
            throw new Exception(t1);
        }
        this.handleCleanups(targetObject, cleanupHandlerAnnotation, null);
        return ret;
    }

    private void handleCleanups(Object target, CleanupHandler handler, Throwable t) throws Exception {
        CleanupHandling[] handlings = handler.value();
        if (handlings.length > 0) {
            for (CleanupHandling handling : handlings) {
                if (handling.always()) {
                    this.doInvokeCleanup(target, handler, handling);
                    continue;
                }
                if (t == null || !t.getClass().equals(handling.exception())) continue;
                this.doInvokeCleanup(target, handler, handling);
            }
        } else {
            this.doInvokeCleanup(target, handler, null);
        }
    }

    private void doInvokeCleanup(Object target, CleanupHandler handler, CleanupHandling handling) throws Exception {
        if (handling == null || !this.invokeCleanups(target, handling.cleanup())) {
            this.invokeCleanups(target, handler.cleanup());
        }
    }

    private boolean invokeCleanups(Object target, Class<?> cleanupClazz) throws Exception {
        if (cleanupClazz != null) {
            for (Method m : target.getClass().getMethods()) {
                Cleanup cleanup = m.getAnnotation(Cleanup.class);
                if (cleanup == null || !cleanup.value().equals(cleanupClazz)) continue;
                m.invoke(target, new Object[0]);
                return true;
            }
        } else {
            return false;
        }
        throw new IllegalArgumentException("Cleanup methode with name '" + cleanupClazz + "' not found in " + target.getClass().getName());
    }
}

