/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.cdi.exception;

import com.blazebit.annotation.AnnotationUtil;
import com.blazebit.annotation.constraint.NullClass;
import com.blazebit.cdi.cleanup.annotation.Cleanup;
import com.blazebit.cdi.exception.annotation.CatchHandler;
import com.blazebit.cdi.exception.annotation.CatchHandling;
import com.blazebit.exception.ExceptionUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.core.api.exception.control.event.ExceptionToCatchEvent;

@Interceptor
@CatchHandler
public class CatchHandlerInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Event<ExceptionToCatchEvent> catchEvent;

    @AroundInvoke
    public Object handle(InvocationContext ic) throws Exception {
        Method m = ic.getMethod();
        Object targetObject = ic.getTarget();
        Class<?> targetClass = targetObject == null ? m.getDeclaringClass() : targetObject.getClass();
        CatchHandler exceptionHandlerAnnotation = (CatchHandler)AnnotationUtil.findAnnotation((Method)m, targetClass, CatchHandler.class);
        Exception unexpectedException = null;
        if (exceptionHandlerAnnotation == null) {
            throw new IllegalStateException("The interceptor annotation can not be determined!");
        }
        CatchHandling[] exceptionHandlingAnnotations = exceptionHandlerAnnotation.value();
        try {
            return ic.proceed();
        }
        catch (Exception ex) {
            Throwable t = ExceptionUtil.unwrapInvocationTargetException((Throwable)ex);
            boolean exceptionHandled = false;
            if (exceptionHandlingAnnotations.length > 0) {
                for (CatchHandling handling : exceptionHandlingAnnotations) {
                    if (!handling.exception().isInstance(t)) continue;
                    try {
                        this.handleThrowable(t);
                        exceptionHandled = true;
                    }
                    catch (Exception unexpected) {
                        unexpectedException = unexpected;
                    }
                    if (handling.cleanup().equals(NullClass.class)) break;
                    this.invokeCleanups(targetClass, targetObject, handling.cleanup());
                    break;
                }
            }
            if (!exceptionHandled && exceptionHandlerAnnotation.exception().isInstance(t)) {
                try {
                    this.handleThrowable(t);
                    exceptionHandled = true;
                }
                catch (Exception unexpected) {
                    unexpectedException = unexpected;
                }
                if (!exceptionHandlerAnnotation.cleanup().equals(NullClass.class)) {
                    this.invokeCleanups(targetClass, targetObject, exceptionHandlerAnnotation.cleanup());
                }
            }
            if (!exceptionHandled) {
                unexpectedException = t instanceof Exception ? (Exception)t : new Exception(t);
            }
            if (unexpectedException != null) {
                throw unexpectedException;
            }
            return null;
        }
    }

    protected void handleThrowable(Throwable t) {
        this.catchEvent.fire((Object)new ExceptionToCatchEvent(t));
    }

    private boolean invokeCleanups(Class<?> clazz, Object target, Class<?> cleanupClazz) throws Exception {
        boolean invoked = false;
        if (!cleanupClazz.equals(NullClass.class)) {
            for (Method m : clazz.getMethods()) {
                Cleanup cleanup = m.getAnnotation(Cleanup.class);
                if (cleanup == null || !cleanup.value().equals(cleanupClazz)) continue;
                m.invoke(target, new Object[0]);
                invoked = true;
            }
        }
        return invoked;
    }
}

