/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.cdi.exception;

import com.blazebit.annotation.AnnotationUtil;
import com.blazebit.cdi.exception.annotation.ExceptionWrap;
import com.blazebit.cdi.exception.annotation.ExceptionWrapping;
import com.blazebit.exception.ExceptionUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@ExceptionWrapping(value={})
public class ExceptionWrappingInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;

    @AroundInvoke
    public Object errorLogging(InvocationContext ic) throws Exception {
        Object ret;
        Logger log = Logger.getLogger(ic.getTarget().getClass().getName());
        Method m = ic.getMethod();
        Object targetObject = ic.getTarget();
        Class<?> targetClass = targetObject == null ? m.getDeclaringClass() : targetObject.getClass();
        Class<?>[] declaredExceptions = m.getExceptionTypes();
        ExceptionWrapping wrappingAnnotation = (ExceptionWrapping)AnnotationUtil.findAnnotation((Method)m, targetClass, ExceptionWrapping.class);
        ExceptionWrap[] wraps = null;
        boolean doWrapping = true;
        if (wrappingAnnotation == null) {
            throw new IllegalStateException("The interceptor annotation can not be determined!");
        }
        wraps = wrappingAnnotation.value();
        doWrapping = wraps != null && wraps.length > 0;
        try {
            ret = ic.proceed();
        }
        catch (Throwable t) {
            Throwable t1 = ExceptionUtil.unwrapInvocationTargetException((Throwable)t);
            if (doWrapping) {
                for (Class<?> declaredException : declaredExceptions) {
                    if (!declaredException.isInstance(t1)) continue;
                    doWrapping = false;
                    break;
                }
                if (doWrapping) {
                    for (ExceptionWrap wrap : wraps) {
                        Class<? extends Throwable>[] sourceClasses = wrap.sources();
                        Class<? extends Exception> wrapperClass = wrap.wrapper();
                        Exception e = null;
                        for (Class<? extends Throwable> source : sourceClasses) {
                            if (!source.isInstance(t1)) continue;
                            try {
                                e = wrapperClass.getConstructor(Throwable.class).newInstance(t1);
                            }
                            catch (Throwable t2) {
                                Exception ex1 = null;
                                ex1 = t2 instanceof Exception ? (Exception)t2 : new Exception(t2);
                                log.log(Level.WARNING, "The applied wrapper exception on the method " + m.getName() + " has no constructor for type Throwable!", ex1);
                            }
                            if (e == null) continue;
                            throw e;
                        }
                    }
                }
            }
            if (t1 instanceof Exception) {
                throw (Exception)t1;
            }
            throw new Exception(t1);
        }
        return ret;
    }
}

