/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.cdi.logging;

import com.blazebit.cdi.logging.annotation.Logging;
import com.blazebit.exception.ExceptionUtil;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Logging
public class LoggingInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;

    @AroundInvoke
    public Object errorLogging(InvocationContext ic) throws Exception {
        Logger log = Logger.getLogger(ic.getTarget().getClass().getName());
        if (!log.isLoggable(Level.FINE)) {
            return ic.proceed();
        }
        Object ret = null;
        String className = ic.getMethod().getDeclaringClass().getSimpleName();
        String methodName = ic.getMethod().getName();
        Class<?> methodReturnType = ic.getMethod().getReturnType();
        StringBuilder sb = new StringBuilder();
        Throwable t = null;
        Object[] o = ic.getParameters();
        sb.append(className).append(methodName).append("(");
        for (int i = 0; i < o.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (o[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(o[i].toString());
        }
        log.log(Level.FINE, sb.append(")").append(" called").toString());
        try {
            ret = ic.proceed();
        }
        catch (Throwable t1) {
            t = t1;
            t = ExceptionUtil.unwrapInvocationTargetException((Throwable)t);
        }
        sb.setLength(0);
        sb.append(className).append(methodName).append("()");
        if (t == null) {
            if (Void.TYPE.equals(methodReturnType)) {
                sb.append(" exited");
            } else {
                sb.append(" returned ");
                if (ret == null) {
                    sb.append("null");
                } else {
                    sb.append(ret.toString());
                }
            }
        } else {
            sb.append(" throwed ");
            sb.append(t.getClass().getSimpleName()).append("() with the message: ");
            if (t.getMessage() != null && !t.getMessage().isEmpty()) {
                sb.append(t.getMessage());
            }
        }
        log.log(Level.FINE, sb.toString());
        if (t != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        return ret;
    }
}

