/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.cdi.transaction;

import com.blazebit.annotation.AnnotationUtil;
import com.blazebit.cdi.transaction.annotation.Transactional;
import com.blazebit.exception.ExceptionUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;

@Transactional
@Interceptor
public class TransactionalInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Resource
    private UserTransaction utx;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AroundInvoke
    public Object applyTransaction(InvocationContext ic) throws Exception {
        Object targetObject;
        Class<?> targetClass;
        Method m = ic.getMethod();
        Transactional transactionalAnnotation = (Transactional)AnnotationUtil.findAnnotation((Method)m, targetClass = (targetObject = ic.getTarget()) == null ? m.getDeclaringClass() : targetObject.getClass(), Transactional.class);
        if (transactionalAnnotation == null) {
            throw new IllegalStateException("The interceptor annotation can not be determined!");
        }
        if (transactionalAnnotation == null) return ic.proceed();
        if (transactionalAnnotation.requiresNew()) throw new UnsupportedOperationException("Not supported yet.");
        boolean startedTransaction = false;
        if (this.utx.getStatus() != 0) {
            this.utx.begin();
            startedTransaction = true;
        }
        try {
            Object ret = ic.proceed();
            if (!startedTransaction) return ret;
            this.utx.commit();
            return ret;
        }
        catch (Throwable t) {
            Throwable t1;
            if (startedTransaction) {
                this.utx.rollback();
            }
            if (!((t1 = ExceptionUtil.unwrapInvocationTargetException((Throwable)t)) instanceof Exception)) throw new Exception(t1);
            throw (Exception)t1;
        }
    }
}

