/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence;

import com.blazebit.persistence.FetchProfile;
import com.blazebit.reflection.ReflectionUtil;
import com.blazebit.text.FormatUtil;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FetchUtil {
    private static final Logger log = Logger.getLogger(FetchUtil.class.getName());

    public static String getFetchProfilePlaceholder(Class<?> clazz) {
        return "FETCH_PROFILE_" + clazz.getSimpleName();
    }

    public static String getFullQualifiedFetchProfilePlaceholder(Class<?> clazz) {
        return "FETCH_PROFILE_" + clazz.getName();
    }

    public static String query(String query, String alias, FetchProfile<?> f) {
        String fetchProfilePlaceholder = FetchUtil.getFetchProfilePlaceholder(f.getClazz());
        int placeholderIndex = query.indexOf(fetchProfilePlaceholder);
        if (placeholderIndex < 0) {
            fetchProfilePlaceholder = FetchUtil.getFullQualifiedFetchProfilePlaceholder(f.getClazz());
            placeholderIndex = query.indexOf(fetchProfilePlaceholder);
        }
        if (placeholderIndex < 0) {
            throw new IllegalArgumentException("The fetch profile placeholder '" + fetchProfilePlaceholder + "' could not be found in the query!");
        }
        StringBuilder querySb = new StringBuilder(query);
        StringBuilder sb = new StringBuilder();
        String[] fields = f.getPropertyPaths();
        HashMap<String, String> classBasedPropertyAliasMap = new HashMap<String, String>();
        block0: for (int i = 0; i < fields.length; ++i) {
            String[] propertyNames = fields[i].split("\\.");
            Class currentClass = f.getClazz();
            String parentElement = alias;
            StringBuilder propertyPath = new StringBuilder();
            for (int j = 0; j < propertyNames.length; ++j) {
                Class[] types;
                boolean fieldMapType;
                String propertyName = propertyNames[j];
                Class fieldClass = ReflectionUtil.getFieldType(currentClass, (String)propertyName);
                boolean fieldCollectionType = ReflectionUtil.isSubtype((Class)fieldClass, Collection.class);
                boolean bl = fieldMapType = fieldCollectionType ? false : ReflectionUtil.isSubtype((Class)fieldClass, Map.class);
                if (fieldCollectionType) {
                    types = ReflectionUtil.getResolvedFieldTypeArguments(currentClass, (String)propertyName);
                    if (types.length != 1) {
                        throw new IllegalArgumentException("No type parameter given for collection type in class " + currentClass + " for field " + propertyName);
                    }
                    fieldClass = types[0];
                } else if (fieldMapType) {
                    types = ReflectionUtil.getResolvedFieldTypeArguments(currentClass, (String)propertyName);
                    if (types.length != 2) {
                        throw new IllegalArgumentException("No type parameter given for map type in class " + currentClass + " for field " + propertyName);
                    }
                    fieldClass = types[1];
                }
                if (fieldClass == null) {
                    throw new IllegalArgumentException("Field with name " + propertyName + " was not found within class " + currentClass.getName());
                }
                if (FormatUtil.isParseableType((Class)fieldClass) || Blob.class.equals((Object)fieldClass) || Clob.class.equals((Object)fieldClass) || new byte[0].getClass().equals(fieldClass)) {
                    log.info("Field with name " + propertyName + " of class " + currentClass.getName() + " is parseable and therefore it has not to be fetched explicitly.");
                    if (i + 1 >= fields.length) continue block0;
                    throw new IllegalArgumentException("Can not fetch anything from a simple property!");
                }
                if (j != 0) {
                    propertyPath.append(".");
                }
                propertyPath.append(propertyName);
                currentClass = fieldClass;
                if (!classBasedPropertyAliasMap.containsKey(propertyPath.toString())) {
                    String currentAlias = "_" + i + "_" + propertyName + "_element_" + j;
                    boolean hasAlias = true;
                    sb.append(" LEFT OUTER JOIN FETCH ");
                    if (!fieldCollectionType && !fieldMapType) {
                        hasAlias = false;
                        currentAlias = parentElement + "." + propertyName;
                    }
                    if (j == 0) {
                        sb.append(parentElement);
                    } else {
                        sb.append((String)classBasedPropertyAliasMap.get(parentElement));
                    }
                    sb.append(".");
                    sb.append(propertyName);
                    if (hasAlias) {
                        sb.append(" ");
                        sb.append(currentAlias);
                    }
                    classBasedPropertyAliasMap.put(propertyPath.toString(), currentAlias);
                }
                parentElement = propertyPath.toString();
            }
        }
        return querySb.replace(placeholderIndex, placeholderIndex + fetchProfilePlaceholder.length(), sb.toString()).toString();
    }
}

